/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.integration.labour.LabourIntegration;
import ordermate.database.integration.labour.LabourSummaryReport;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.StaffCostReport;
import ordermate.database.reports.StaffCostReportSummary;
import ordermate.database.searchers.reports.TotalsReportSearcher;

public class StaffCostReportHelper {
    public static final TotalsReport ZERO = new TotalsReport();

    public Price getLabourCost(List<StaffCostReport> staffCostReport) {
        Price totalLabourCost = Price.ZERO_DOLLAR;
        for (StaffCostReport reportItem : staffCostReport) {
            totalLabourCost = totalLabourCost.add(reportItem.getLabourCost());
        }
        return totalLabourCost;
    }

    public String getLabourPercentageString(List<StaffCostReport> staffCostReport, TotalsReport report) {
        return FinanceUtils.formatAsPercentage(this.getLabourPercentage(staffCostReport, report) * 100.0);
    }

    public double getLabourPercentage(List<StaffCostReport> staffCostReport, TotalsReport report) {
        if (report == null) {
            throw new IllegalArgumentException("Totals report should not be null");
        }
        if (report.getTotal() == null || report.getTotal().isZero()) {
            return 1.0;
        }
        return this.getLabourCost(staffCostReport).doubleValue() / report.getTotal().doubleValue();
    }

    public double getLabourHours(List<StaffCostReport> staffCostReports) {
        double value = 0.0;
        for (StaffCostReport report : staffCostReports) {
            value += report.getLabourHours();
        }
        return value;
    }

    public Price getSalesPerLabourHour(List<StaffCostReport> staffCostReport, TotalsReport report) {
        double totalLabourHours = this.getTotalLabourHours(staffCostReport);
        if (MathsUtils.approxEquals(totalLabourHours, 0.0)) {
            return Price.ZERO_DOLLAR;
        }
        return report.getTotal().divide(totalLabourHours);
    }

    public double getTotalLabourHours(List<StaffCostReport> staffCostReport) {
        double totalHours = 0.0;
        for (StaffCostReport reportItem : staffCostReport) {
            totalHours += reportItem.getLabourHours();
        }
        return totalHours;
    }

    public List<StaffCostReport> getStaffCostReports(Date startRange, Date endRange) {
        Date timeNow = Calendar.getInstance().getTime();
        if (endRange == null || endRange.after(timeNow)) {
            endRange = timeNow;
        }
        if (startRange.after(endRange)) {
            return new ArrayList<StaffCostReport>();
        }
        StringBuilder query = new StringBuilder("SELECT IF(? < time_in, time_in, ?) as range_in, IF(? > time_out, time_out, ?) as range_out, fk_config_user, pay_rate FROM (SELECT IF (mod_time_in is null, time_IN, mod_time_in) as time_in, IF (mod_time_out is null, time_OUT, mod_time_out) as time_out, fk_config_user, pay_rate FROM finance_timesheet) AS finance_timesheet LEFT JOIN config_user ON config_user.id = finance_timesheet.fk_config_user WHERE time_in < ? and ((time_out > ?) or time_out is null) AND config_user.system_state = 'ACTIVE' ");
        if (SystemProperty.getInstance().isLabourFiguresClockedOffOnly()) {
            query.append("AND finance_timesheet.time_OUT IS NOT NULL");
        }
        return PersistenceManager.getObjectList(StaffCostReport.class, query.toString(), new Object[]{startRange, startRange, endRange, endRange, endRange, startRange});
    }

    public StaffCostReportSummary getStaffCostReportSummary(Date startTime, Date endTime) {
        return this.getStaffCostReportSummary(startTime, endTime, null);
    }

    public StaffCostReportSummary getStaffCostReportSummary(Date startTime, Date endTime, List<SalesLocation> salesLocations) {
        LabourIntegration integration = LabourIntegration.getInstance();
        if (integration.isPersistent() && integration.isActive()) {
            return this.doSummaryReportByIntegration(integration, startTime, endTime, salesLocations);
        }
        return this.doSummaryReportByInternal(startTime, endTime, salesLocations);
    }

    private StaffCostReportSummary doSummaryReportByIntegration(LabourIntegration integration, Date startTime, Date endTime, List<SalesLocation> salesLocations) {
        Date timeNow = Calendar.getInstance().getTime();
        if (endTime == null || endTime.after(timeNow)) {
            endTime = timeNow;
        }
        StaffCostReportSummary summary = new StaffCostReportSummary();
        TotalsReport total = this.getTotals(startTime, endTime, salesLocations);
        summary.setStartTime(startTime);
        summary.setEndTime(endTime);
        List<LabourSummaryReport> reports = PersistenceManager.getObjectList(LabourSummaryReport.class, Query.select(LabourSummaryReport.class).equals(LabourSummaryReport.Properties.REPORT_DATE, startTime, SQLDateType.DATE).toString());
        double totalHours = 0.0;
        double totalCost = 0.0;
        for (LabourSummaryReport report : reports) {
            totalHours += report.getTotalHours();
            totalCost += report.getTotalCost();
        }
        summary.setLabourPercentage(total.getTotal() == null || total.getTotal().isZero() ? 1.0 : totalCost / total.getTotal().doubleValue());
        summary.setSalesPerLabourHour(total.getTotal() == null || total.getTotal().isZero() ? Price.ZERO_DOLLAR : total.getTotal().divide(totalHours));
        summary.setStaffCost(new Price(totalCost, Price.DEFAULT_ROUND_AMOUNT));
        summary.setTotalPeriodSales(total.getTotal());
        summary.setTotalLabourHours(totalHours);
        return summary;
    }

    private StaffCostReportSummary doSummaryReportByInternal(Date startTime, Date endTime, List<SalesLocation> salesLocations) {
        List<StaffCostReport> staffCostReports = this.getStaffCostReports(startTime, endTime);
        StaffCostReportSummary summary = new StaffCostReportSummary();
        TotalsReport total = this.getTotals(startTime, endTime, salesLocations);
        summary.setStartTime(startTime);
        summary.setEndTime(endTime);
        summary.setLabourPercentage(this.getLabourPercentage(staffCostReports, total));
        summary.setSalesPerLabourHour(this.getSalesPerLabourHour(staffCostReports, total));
        summary.setStaffCost(this.getLabourCost(staffCostReports));
        summary.setTotalPeriodSales(total.getTotal());
        summary.setTotalLabourHours(this.getLabourHours(staffCostReports));
        return summary;
    }

    private TotalsReport getTotals(Date startTime, Date endTime, List<SalesLocation> salesLocations) {
        List report;
        TotalsReportSearcher totalsSearcher = new TotalsReportSearcher();
        IRangedQuerySearchFilter<Date> rangeFilter = totalsSearcher.getSalesDateTimeRangeFilter();
        rangeFilter.setStart(startTime);
        if (endTime == null) {
            rangeFilter.setEnd(new Date());
        } else {
            rangeFilter.setEnd(endTime);
        }
        if (salesLocations != null) {
            totalsSearcher.setTradingDayBySIQ(true);
            totalsSearcher.getSalesLocationFilter().setSearchValue(salesLocations);
        }
        TotalsReport total = (report = totalsSearcher.search()).size() == 0 ? ZERO : (TotalsReport)report.get(0);
        return total;
    }
}

