/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StaffCostReportSummary
implements Serializable {
    private Date startTime;
    private Date endTime;
    private double labourPercentage;
    private Price staffCost;
    private Price totalPeriodSales;
    private Price salesPerLabourHour;
    private double totalLabourHours;
    private SimpleDateFormat format = new SimpleDateFormat("h:mma");

    public Date getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "Labour: " + this.getStaffCost() + ", " + FinanceUtils.formatAsPercentage(this.getLabourPercentage()) + ", " + this.getSalesPerLabourHour() + "/Labour Hr";
    }

    protected void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    protected void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public double getLabourPercentage() {
        return this.labourPercentage * 100.0;
    }

    protected void setLabourPercentage(double labourPercentage) {
        this.labourPercentage = labourPercentage;
    }

    public Price getStaffCost() {
        return this.staffCost;
    }

    protected void setStaffCost(Price staffCost) {
        this.staffCost = staffCost;
    }

    public Price getTotalPeriodSales() {
        return this.totalPeriodSales;
    }

    protected void setTotalPeriodSales(Price totalPeriodSales) {
        this.totalPeriodSales = totalPeriodSales;
    }

    public Price getSalesPerLabourHour() {
        return this.salesPerLabourHour;
    }

    protected void setSalesPerLabourHour(Price salesPerLabourHour) {
        this.salesPerLabourHour = salesPerLabourHour;
    }

    public String getTimeRange() {
        return this.format.format(this.getStartTime()) + "-" + this.format.format(this.getEndTime());
    }

    public double getTotalLabourHours() {
        return this.totalLabourHours;
    }

    protected void setTotalLabourHours(double value) {
        this.totalLabourHours = value;
    }
}

