/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@AccessType(value="property")
public class StoreGroupMonthlySales
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private int month;
    private int year;
    private Integer cashSales = 0;
    private int cashGrossProfitPercent;
    private int costOfGoods;
    private Integer debtors = 0;
    private Integer cashCustomersNumber = 0;
    private int wastage;
    private int stockOnHand;
    private Date sent;
    private Date lastStockTake;

    public static List findNotSent() {
        return PersistenceManager.getObjectList(StoreGroupMonthlySales.class, Query.select(StoreGroupMonthlySales.class).isNull(StoreGroupMonthlySales.Properties.SENT).toString(), null);
    }

    public static StoreGroupMonthlySales findByMonth(int month, int year) {
        return PersistenceManager.getObject(StoreGroupMonthlySales.class, Query.select(StoreGroupMonthlySales.class).equalsParam(StoreGroupMonthlySales.Properties.MONTH).equalsParam(StoreGroupMonthlySales.Properties.YEAR).toString(), new Object[]{month, year});
    }

    public static StoreGroupMonthlySales findPreviousMonth(int month, int year) {
        int mm = month - 1;
        int yy = year;
        if (mm == 0) {
            mm = 12;
            --yy;
        }
        return StoreGroupMonthlySales.findByMonth(mm, yy);
    }

    @Column(name="cash_customers_number")
    public Integer getCashCustomersNumber() {
        return this.cashCustomersNumber;
    }

    public void setCashCustomersNumber(Integer cashCustomersNumber) {
        this.cashCustomersNumber = cashCustomersNumber;
    }

    @Transient
    public int getCashGrossProfitPercent() {
        return this.cashGrossProfitPercent;
    }

    public void setCashGrossProfitPercent(int cashGrossProfitPercent) {
        this.cashGrossProfitPercent = cashGrossProfitPercent;
    }

    @Column(name="cash_sales")
    public Integer getCashSales() {
        return this.cashSales;
    }

    public void setCashSales(Integer cashSales) {
        this.cashSales = cashSales;
    }

    @Transient
    public int getCostOfGoods() {
        return this.costOfGoods;
    }

    public void setCostOfGoods(int costOfGoods) {
        this.costOfGoods = costOfGoods;
    }

    @Column(name="debtors")
    public Integer getDebtors() {
        return this.debtors;
    }

    public void setDebtors(Integer debtors) {
        this.debtors = debtors;
    }

    @Column(name="month")
    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        if (month > 12 || month < 1) {
            throw new IllegalArgumentException("The month " + month + " is not between 1 and 12.");
        }
        this.month = month;
    }

    @Column(name="year")
    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    @Transient
    public Date getSent() {
        return this.sent;
    }

    public void setSent(Date sent) {
        this.sent = sent;
    }

    @Transient
    public int getStockOnHand() {
        return this.stockOnHand;
    }

    public void setStockOnHand(int stockOnHand) {
        this.stockOnHand = stockOnHand;
    }

    @Transient
    public int getWastage() {
        return this.wastage;
    }

    public void setWastage(int wastage) {
        this.wastage = wastage;
    }

    @Transient
    public Date getLastStockTake() {
        return this.lastStockTake;
    }

    public void setLastStockTake(Date lastStockTake) {
        this.lastStockTake = lastStockTake;
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.month > 12 || this.month < 1) {
            throw new IllegalStateException("The month " + this.month + " is not between 1 and 12.");
        }
        PersistenceManager.save(this);
    }

    @Override
    public String toString() {
        return this.month + "-" + this.year;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property MONTH;
        public PropertiedObject.Property YEAR;
        public PropertiedObject.Property CASH_SALES;
        public PropertiedObject.Property CASH_GROSS_PROFIT_PERCENT;
        public PropertiedObject.Property DEBTORS;
        public PropertiedObject.Property CASH_CUSTOMERS_NUMBER;
        public PropertiedObject.Property COST_OF_GOODS;
        public PropertiedObject.Property WASTAGE;
        public PropertiedObject.Property STOCK_ON_HAND;
        public PropertiedObject.Property LAST_STOCK_TAKE;
        public PropertiedObject.Property SENT;
    }
}

