/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.stock.StockOnHandQueries;
import ordermate.database.reports.StoreGroupMonthlySales;
import ordermate.database.sales.Account;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockWastage;

public class StoreGroupMonthlySalesManager {
    public static final String FILE_NAME = "/store_group_monthly.csv";
    private final double taxCoef;
    private final int month;
    private final int year;
    private final StoreGroupMonthlySales current;
    private final Date start;
    private final Date end;
    private final StoreGroupMonthlySales previous;

    public StoreGroupMonthlySalesManager(int month, int year) {
        this.month = month;
        this.year = year;
        this.taxCoef = SystemProperty.getInstance().getBaseTaxFactor();
        this.previous = StoreGroupMonthlySales.findPreviousMonth(month, year);
        StoreGroupMonthlySales existing = StoreGroupMonthlySales.findByMonth(month, year);
        boolean isNew = true;
        if (existing == null) {
            this.current = new StoreGroupMonthlySales();
        } else {
            this.current = existing;
            this.current.setCashCustomersNumber(0);
            this.current.setCashGrossProfitPercent(0);
            this.current.setCashSales(0);
            this.current.setCostOfGoods(0);
            this.current.setDebtors(0);
            this.current.setWastage(0);
            this.current.setSent(null);
            isNew = false;
        }
        Date[] dateRange = DateTimeUtils.getMonthlyDateRange(year, month - 1);
        this.start = dateRange[0];
        this.end = dateRange[1];
        this.current.setMonth(month);
        this.current.setYear(year);
        this.getSales();
        if (isNew) {
            this.getStockOnHand();
        }
        this.getCOGS();
        this.getWastage();
        if (isNew) {
            this.getLastStockTake();
        }
    }

    public StoreGroupMonthlySales getMonthlySales() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishResult() {
        StringBuilder sb = new StringBuilder("Monthly results for ");
        sb.append(this.month);
        sb.append("-");
        sb.append(this.year);
        sb.append(",");
        sb.append(this.current.getCashSales());
        sb.append(",");
        sb.append(this.current.getCashGrossProfitPercent());
        sb.append("%,");
        sb.append(this.current.getCostOfGoods());
        sb.append(",");
        sb.append(this.current.getDebtors());
        sb.append(",");
        sb.append(this.current.getCashCustomersNumber());
        sb.append(",");
        sb.append(this.current.getWastage());
        sb.append(",");
        sb.append(this.current.getStockOnHand());
        sb.append("\n");
        OrderMate.LOG.info("Publish monthly store group report /store_group_monthly.csv with " + sb.toString());
        String outputDir = StoreGroup.getExistingOutputDir();
        File file = new File(outputDir + FILE_NAME);
        BufferedWriter out = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                OrderMate.LOG.error("Could not create the file " + file);
            }
            out = new BufferedWriter(new FileWriter(file, true));
            out.write(sb.toString());
        }
        catch (IOException e) {
            OrderMate.LOG.error("Error writing to file " + file, (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.debug("Error closing file " + file, (Throwable)ex);
                }
            }
        }
    }

    private void getLastStockTake() {
        try {
            StockTake lastSavedStockTake = StockTake.getLastSavedStockTake();
            if (lastSavedStockTake != null) {
                this.current.setLastStockTake(lastSavedStockTake.getDate());
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private void getSales() {
        try {
            TradingDay endDay;
            TradingDay startDay = TradingDay.ReportDates.getFirstTradingDayForDate(this.start);
            if (startDay != null && startDay.getDate().compareTo(this.end) <= 0 && (endDay = TradingDay.ReportDates.getLastTradingDayForDate(this.end)) != null && endDay.getDate().compareTo(this.start) >= 0) {
                List accounts = this.retrieveAccounts(startDay, endDay);
                this.getAccountValue(accounts);
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private void getAccountValue(List accounts) {
        try {
            Price sumCash = Price.ZERO_DOLLAR;
            Price sumDebtor = Price.ZERO_DOLLAR;
            Price cashCost = Price.ZERO_DOLLAR;
            int cashCustomer = 0;
            Iterator it = accounts.iterator();
            while (it.hasNext()) {
                Account account = (Account)it.next();
                Price total = Price.ZERO_DOLLAR;
                try {
                    total = account.getSavedTotal();
                }
                catch (IllegalStateException ise) {
                    OrderMate.LOG.error((Object)ise);
                }
                total = total.subtract(account.getTax());
                if (account.isPaidWithMoney()) {
                    sumCash = sumCash.add(total);
                    ++cashCustomer;
                    cashCost = cashCost.add(account.getCost());
                } else {
                    sumDebtor = sumDebtor.add(total);
                }
                it.remove();
            }
            this.current.setCashSales(this.round(sumCash.doubleValue()));
            this.current.setDebtors(this.round(sumDebtor.doubleValue()));
            this.current.setCashCustomersNumber(cashCustomer);
            if (this.round(sumCash.doubleValue()) != 0) {
                int margin = this.round(sumCash.subtract(cashCost).doubleValue());
                this.current.setCashGrossProfitPercent((int)((double)margin * 100.0 / (double)this.round(sumCash.doubleValue())));
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private void getStockOnHand() {
        try {
            Object[][] closingStockOnHandData = PersistenceManager.getPersistenceDelegate().executeQuery(StockOnHandQueries.Reports.GetStockOnHandByTax.getQuery().getSQL(), null);
            double sum = 0.0;
            for (int i = 0; i < closingStockOnHandData.length; ++i) {
                Number number = (Number)closingStockOnHandData[i][0];
                double value = number.doubleValue();
                Boolean incTax = (Boolean)closingStockOnHandData[i][1];
                if (incTax.booleanValue()) {
                    value *= this.taxCoef;
                }
                sum += value;
            }
            this.current.setStockOnHand(this.round(sum));
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private List retrieveAccounts(TradingDay startDay, TradingDay endDay) {
        ObjectQuery select = Query.select(Account.class).wherePropertyBetween(Account.Properties.TRADING_DAY, startDay.getID(), endDay.getID());
        return PersistenceManager.getObjectList(Account.class, select.toString(), null);
    }

    private void getCOGS() {
        if (this.previous == null) {
            return;
        }
        try {
            int cogs = this.previous.getStockOnHand() - this.current.getStockOnHand();
            this.current.setCostOfGoods(cogs += this.getPurchase());
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private int getPurchase() {
        Price cost = new Price(0.0, 0.0);
        List invoices = StockInvoice.getStockInvoicesForDates(this.start, this.end);
        for (StockInvoice invoice : invoices) {
            cost = cost.add(invoice.getTotalCostExTax());
        }
        return this.round(cost.doubleValue());
    }

    private void getWastage() {
        try {
            double cost = 0.0;
            List<StockWastage> wastages = StockWastage.getWastages(this.start, this.end);
            for (StockWastage wastage : wastages) {
                double itemCost = wastage.getHistoricalCost().doubleValue();
                if (wastage.getStockItem().isTaxIncluded()) {
                    itemCost *= this.taxCoef;
                }
                cost += itemCost;
            }
            this.current.setWastage(this.round(cost));
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
        }
    }

    private int round(double n) {
        return (int)Math.round(n);
    }
}

