/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;

public class TimesheetReportSummary
implements PropertiedObject {
    public static final Props Properties = new Props();
    private String payroll;
    private String user;
    private String department;
    private Double totalHours;
    private Price totalPay;

    public TimesheetReportSummary(String payroll, String userName, String department) {
        this.payroll = payroll;
        this.user = userName;
        this.department = department;
        this.totalHours = new Double(0.0);
        this.totalPay = Price.ZERO_NO_ROUND;
    }

    public void addTotalHours(double totalhrs) {
        this.totalHours = new Double(this.totalHours + totalhrs);
    }

    public void addTotalPay(Price totalPay) {
        this.totalPay = this.totalPay.add(totalPay);
    }

    public final String getUser() {
        return this.user;
    }

    public final String getDepartment() {
        return this.department;
    }

    public final Double getTotalHours() {
        return this.totalHours;
    }

    public final Price getTotalPay() {
        return this.totalPay;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public String getPayroll() {
        return this.payroll == null ? "" : this.payroll;
    }

    protected void setPayroll(String value) {
        this.payroll = value;
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<String> PAYROLL;
        public PropertiedObject.Property<String> USER;
        public PropertiedObject.Property<String> DEPARTMENT;
        public PropertiedObject.Property<Double> TOTAL_HOURS;
        public PropertiedObject.Property<Price> TOTAL_PAY;
    }
}

