/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.accounttotals;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.finance.reports.AccountTotalsReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.searchers.reports.AccountTotalsReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class AccountTotalsReportProvider
extends AbstractReportProvider {
    private AccountTotalsReportSearcher searcher;

    public AccountTotalsReportProvider(AccountTotalsReportSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<AccountTotalsReportSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.setTitle("Account Totals");
        builder.addMinimalistBusinessDetails();
        StringBuilder SB = new StringBuilder();
        if (this.searcher.getTradingDayDateFilter().hasSearchValue()) {
            this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateFilter(), this.searcher.getTimeFilter());
        }
        new ReportProviderHelper().appendSearchFilter(SB, "Trading Day", this.searcher.getTradingDayFilter());
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(AccountTotalsReport.Properties.ACCOUNT_TYPE, "Account Type", null);
        builder.addReportColumn(AccountTotalsReport.Properties.ACCOUNT_STATE, "Account State", null);
        builder.addReportColumn(AccountTotalsReport.Properties.COUNT, "Count", "0");
        builder.addReportColumn(AccountTotalsReport.Properties.AVERAGE, "Average", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(AccountTotalsReport.Properties.TOTAL, "Total", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(AccountTotalsReport.Properties.TOTAL_TAX, "TotalTax", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

