/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.accounttotals;

import au.com.ordermate.oquery.GroupBy;
import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import ordermate.database.reports.accounttotals.AccountTotalsReportProvider;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.sales.Account;
import ordermate.database.searchers.reports.AccountTotalsReportSearcher;

@MakesReport(value="Account Sales", description="View sales, count and tax for a period by account type", category="Sales & Takings", columnMetaData={@ReportConfigureColumnMetaData(name="Count", totaled=true), @ReportConfigureColumnMetaData(name="Total", totaled=true), @ReportConfigureColumnMetaData(name="TotalTax", totaled=true), @ReportConfigureColumnMetaData(name="Account Type", grouped=1, locked=true), @ReportConfigureColumnMetaData(name="Account State", grouped=2)})
public class AccountTypeReportMaker
extends ConfigurableReportMaker<AccountTotalsReportSearcher, AccountTotalsReportProvider> {
    @Override
    protected AccountTotalsReportSearcher createSearchFilter() {
        String timeFilterValue = this.retrieveFilterValueFor("Time");
        boolean isSupportCrossDay = false;
        if (timeFilterValue != null && timeFilterValue.contains("h")) {
            isSupportCrossDay = true;
        }
        return new AccountTotalsReportSearcher(new GroupBy(Account.Properties.ACCOUNT_TYPE), isSupportCrossDay);
    }

    @Override
    protected AccountTotalsReportProvider createReportProvider(AccountTotalsReportSearcher yourSearcher) {
        return new AccountTotalsReportProvider(yourSearcher);
    }
}

