/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.adjustments;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateTimeExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public abstract class AdjustmentsReportProvider
extends AbstractReportProvider {
    private final AdjustmentsReportSearcher searcher;
    private final SearcherDataSourceProvider dsProvider;
    private ReportBuilder builder;
    private volatile DynamicReport report = null;
    private String title;
    private PropertiedObject.Property groupBy;
    private User user;

    public AdjustmentsReportProvider(AdjustmentsReportSearcher searcherToUse, PropertiedObject.Property groupByProperty, String reportTitle) throws BuilderException {
        this.groupBy = groupByProperty;
        this.searcher = searcherToUse;
        this.dsProvider = new SearcherDataSourceProvider<AdjustmentsReportSearcher>(this.searcher, this.groupBy);
        this.title = reportTitle;
        this.searcher.initWebFilter();
    }

    private void initBuilder() throws BuilderException {
        this.builder = new ReportBuilder(new OrderMateDefaultReportStyle(){

            @Override
            protected Style constructTitleStyle() {
                Style style = new Style();
                style.setFont(new Font(16, "Verdana", true));
                return style;
            }

            @Override
            protected Style constructSubtitleStyle() {
                Style style = new Style();
                style.setFont(new Font(8, "Verdana", false));
                style.setVerticalAlign(VerticalAlign.TOP);
                style.setTextColor(Color.GRAY);
                return style;
            }
        });
        this.builder.getCustomExpressionRegister().put(Date.class, new DateTimeExpressionBuilder());
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        ArrayList<PropertiedObject.Property> properties = new ArrayList<PropertiedObject.Property>();
        PropertiedObject.Property[] propsToAdd = this.getColumnProperties();
        properties.addAll(Arrays.asList(propsToAdd));
        properties.remove(this.groupBy);
        properties.add(0, this.groupBy);
        if (!properties.contains(AdjustmentsReport.Properties.COST)) {
            properties.add(AdjustmentsReport.Properties.COST);
        }
        this.builder.addReportColumns(properties);
        if (properties.contains(AdjustmentsReport.Properties.TARGET_UNIT)) {
            this.builder.getPropertyColumn(AdjustmentsReport.Properties.TARGET_UNIT).setTitle("Unit");
            this.builder.getPropertyColumn(AdjustmentsReport.Properties.QUANTITY).setTitle("Qty");
        }
        if (properties.contains(AdjustmentsReport.Properties.INVENTORY_ITEM_UNIT_ID)) {
            this.builder.getPropertyColumn(AdjustmentsReport.Properties.INVENTORY_ITEM_UNIT_ID).setTitle("Unit ID");
        }
        this.builder.getPropertyColumn(AdjustmentsReport.Properties.COST).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        DJGroup group = this.builder.addGroupBy(this.groupBy, Arrays.asList(new ReportBuilder.PropertyCalculation(AdjustmentsReport.Properties.COST, DJCalculation.SUM)));
        this.builder.createBarChart(group, ReportBuilder.ChartCalculation.SUM, Arrays.asList(this.builder.getPropertyColumn(AdjustmentsReport.Properties.COST)), (byte)2, new DJAxisFormat("Value (" + Internationalization.getLiteralFor("DOLLAR_SIGN") + ")"));
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(AdjustmentsReport.Properties.COST), DJCalculation.SUM, null);
        PriceAdjustmentDirection direction = this.searcher.getDirectionSearchFilter().getSearchValue();
        if (direction != null) {
            this.builder.getReportBuilder().setGrandTotalLegend("Total " + direction.getLabel() + "s");
        } else {
            this.builder.getReportBuilder().setGrandTotalLegend("Total Adjustments");
        }
    }

    protected abstract PropertiedObject.Property[] getColumnProperties();

    @Override
    public ReportBuilder getBuilder() {
        try {
            this.initBuilder();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create Adjustments Report", (Throwable)ex);
        }
        return this.builder;
    }

    @Override
    public DynamicReport getReport() throws BuilderException {
        if (this.getUser() != null) {
            this.addParam("user", this.getUser().getName());
        }
        this.report = this.getBuilder().buildJasperReport();
        this.report.setTitle(this.title);
        this.report.setSubtitle(this.getDisplayableListOfFilters());
        return this.report;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dsProvider.getDataSource();
    }

    public AdjustmentsReportSearcher getSearcher() {
        return this.searcher;
    }

    public void setUser(User aUser) {
        this.user = aUser;
    }

    public User getUser() {
        return this.user;
    }

    private String getDisplayableListOfFilters() {
        StringBuilder sb = new StringBuilder();
        if (this.searcher.isPerUnit()) {
            sb.append("Per Unit ");
        }
        sb.append(this.searcher.getDisplayableDate());
        this.getHelper().appendSubTitleAndValue(sb, "Day Part", this.searcher.getTimeFilter().getDisplayableTime());
        this.getHelper().appendSearchFilter(sb, "User", this.searcher.getUserSearchFilter());
        this.getHelper().appendSearchFilter(sb, "Level", this.searcher.getLevelFilter());
        this.getHelper().appendSearchFilter(sb, "Type", this.searcher.getTypeSearchFilter());
        this.getHelper().appendSearchFilter(sb, "Sales Location", this.searcher.getSalesLocationFilter());
        return sb.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        String adjustmentType = "Adjustment";
        if (this.getSearcher().getDirectionSearchFilter().hasSearchValue()) {
            adjustmentType = this.getSearcher().getDirectionSearchFilter().getSearchValue().getLabel();
        }
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeQueryLink(this.searcher.getObjectQuery().toString()) + System.getProperty("line.separator") + adjustmentType + "s on this report reflect when the " + adjustmentType + " was applied, not when the sales took place";
    }
}

