/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.adjustments;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.reports.adjustments.AdjustmentsReportSummary;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;

public class AdjustmentsReportSummaryCompiler<T> {
    private AdjustmentsReportSearcher searcher;
    private PropertiedObject.Property<T> toGroupBy;
    private Map<T, AdjustmentsReportSummary> compilerMap;
    private final String LOOSE_FILTERING_REGEX = "[^-]-{1}\\s?\\$(\\d*\\.)?\\d+$";

    public AdjustmentsReportSummaryCompiler(AdjustmentsReportSearcher searcher, PropertiedObject.Property<T> groupBy) {
        this.searcher = searcher;
        this.toGroupBy = groupBy;
        this.compilerMap = new HashMap<T, AdjustmentsReportSummary>();
    }

    private List<AdjustmentsReport> getSearcherResults() {
        if (!this.searcher.hasSearchValues()) {
            return new ArrayList<AdjustmentsReport>();
        }
        return this.searcher.search();
    }

    public Collection<AdjustmentsReportSummary> getDataSource() {
        this.compilerMap.clear();
        return this.isSurcharge() && this.isGroupingByName() ? this.getLooselyFilteredByName() : this.getDefaultDataSource();
    }

    private Collection<AdjustmentsReportSummary> getDefaultDataSource() {
        List<AdjustmentsReport> results = this.getSearcherResults();
        for (AdjustmentsReport reportObj : results) {
            T propReportObject = reportObj.getPropertyValue(this.toGroupBy);
            if (!this.compilerMap.containsKey(reportObj.getPropertyValue(this.toGroupBy))) {
                this.compilerMap.put(propReportObject, new AdjustmentsReportSummary(propReportObject));
            }
            this.compilerMap.get(propReportObject).addTotal(reportObj.getCost());
        }
        return this.compilerMap.values();
    }

    private Collection<AdjustmentsReportSummary> getLooselyFilteredByName() {
        List<AdjustmentsReport> results = this.getSearcherResults();
        Pattern pattern = Pattern.compile("[^-]-{1}\\s?\\$(\\d*\\.)?\\d+$");
        for (AdjustmentsReport reportObj : results) {
            Matcher matcher;
            T propReportObject = reportObj.getPropertyValue(this.toGroupBy);
            String name = (String)propReportObject;
            if (propReportObject instanceof String && (matcher = pattern.matcher(name)).find()) {
                name = name.substring(0, name.indexOf("-") - 1);
            }
            if ("Custom".equals(reportObj.getType())) {
                name = "Custom";
                if (!StringUtils.isEmpty(reportObj.getSource())) {
                    name = name + "-" + reportObj.getSource();
                }
            } else if ("Open Price".equals(reportObj.getType())) {
                name = "Open Price";
            }
            if (!this.compilerMap.containsKey(name)) {
                this.compilerMap.put(name, new AdjustmentsReportSummary(name));
            }
            this.compilerMap.get(name).addTotal(reportObj.getCost());
        }
        return this.compilerMap.values();
    }

    private boolean isSurcharge() {
        return PriceAdjustmentDirection.SURCHARGE.equals(this.searcher.getDirectionSearchFilter().getSearchValue());
    }

    private boolean isGroupingByName() {
        return AdjustmentsReport.Properties.NAME.equals(this.toGroupBy);
    }
}

