/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.adjustments;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.persistence.PropertiedObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.adjustments.AdjustmentsReportSummary;
import ordermate.database.reports.adjustments.AdjustmentsReportSummaryCompiler;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateTimeExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public abstract class AdjustmentsSummaryReportProvider
extends AbstractReportProvider {
    private final AdjustmentsReportSearcher searcher;
    private final ReportBuilder builder = new ReportBuilder(new OrderMateDefaultReportStyle(){

        @Override
        protected Style constructTitleStyle() {
            Style style = new Style();
            style.setFont(new Font(16, "Verdana", true));
            return style;
        }

        @Override
        protected Style constructSubtitleStyle() {
            Style style = new Style();
            style.setFont(new Font(8, "Verdana", false));
            style.setVerticalAlign(VerticalAlign.TOP);
            style.setTextColor(Color.GRAY);
            return style;
        }
    });
    private volatile DynamicReport report = null;
    private String title;
    private PropertiedObject.Property groupBy;
    private User user;

    public AdjustmentsSummaryReportProvider(AdjustmentsReportSearcher searcherToUse, PropertiedObject.Property groupByProperty, String reportTitle) throws BuilderException {
        this.groupBy = groupByProperty;
        this.searcher = searcherToUse;
        this.title = reportTitle;
        this.initBuilder();
    }

    private void initBuilder() throws BuilderException {
        this.builder.getCustomExpressionRegister().put(Date.class, new DateTimeExpressionBuilder());
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        ArrayList<PropertiedObject.Property> properties = new ArrayList<PropertiedObject.Property>();
        PropertiedObject.Property[] propsToAdd = new PropertiedObject.Property[]{AdjustmentsReportSummary.Properties.REPORT_OBJECT, AdjustmentsReportSummary.Properties.NUM_OF_OBJECT, AdjustmentsReportSummary.Properties.TOTAL};
        properties.addAll(Arrays.asList(propsToAdd));
        this.builder.addReportColumns(properties);
        this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.REPORT_OBJECT).setTitle(this.groupBy.getUserVisibleLabel());
        this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.NUM_OF_OBJECT).setTitle("# Uses");
        this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.TOTAL).setTitle("Cost Total");
        this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.TOTAL).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.NUM_OF_OBJECT).setPattern("0");
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.NUM_OF_OBJECT), DJCalculation.SUM, null);
        this.builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)this.builder.getPropertyColumn(AdjustmentsReportSummary.Properties.TOTAL), DJCalculation.SUM, null);
        PriceAdjustmentDirection direction = this.searcher.getDirectionSearchFilter().getSearchValue();
        if (direction != null) {
            this.builder.getReportBuilder().setGrandTotalLegend("Total " + direction.getLabel() + "s");
        } else {
            this.builder.getReportBuilder().setGrandTotalLegend("Total Adjustments");
        }
    }

    @Override
    public ReportBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        if (this.report == null) {
            if (this.getUser() != null) {
                this.addParam("user", this.getUser().getName());
            }
            this.report = this.builder.buildJasperReport();
        }
        this.report.setTitle(this.title);
        this.report.setSubtitle(this.getDisplayableListOfFilters());
        return this.report;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(new AdjustmentsReportSummaryCompiler(this.searcher, this.groupBy).getDataSource());
    }

    public AdjustmentsReportSearcher getSearcher() {
        return this.searcher;
    }

    public void setUser(User aUser) {
        this.user = aUser;
    }

    public User getUser() {
        return this.user;
    }

    private String getDisplayableListOfFilters() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.searcher.getDisplayableDate());
        this.getHelper().appendSubTitleAndValue(sb, "Day Part", this.searcher.getTimeFilter().getDisplayableTime());
        this.getHelper().appendSearchFilter(sb, "User", this.searcher.getUserSearchFilter());
        this.getHelper().appendSearchFilter(sb, "Level", this.searcher.getLevelFilter());
        this.getHelper().appendSearchFilter(sb, "Type", this.searcher.getTypeSearchFilter());
        this.getHelper().appendSearchFilter(sb, "Sales Location", this.searcher.getSalesLocationFilter());
        return sb.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        String adjustmentType = "Adjustment";
        if (this.getSearcher().getDirectionSearchFilter().hasSearchValue()) {
            adjustmentType = this.getSearcher().getDirectionSearchFilter().getSearchValue().getLabel();
        }
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.searcher.getTradingDayDateRangeFilter()) + System.getProperty("line.separator") + adjustmentType + "s on this report reflect when the " + adjustmentType + " was applied, not when the sales took place";
    }
}

