/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.adjustments;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.reports.MakesReport;
import ordermate.OrderMate;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.reports.adjustments.AdjustmentsReportProvider;
import ordermate.database.reports.adjustments.UserAdjustmentsReportProvider;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;

@MakesReport(value="Surcharges By User", description="View surcharges for a given date range by user.", category="Audit", subcategory="Surcharges")
public class UserSurchargesReportMaker
extends ConfigurableReportMaker<AdjustmentsReportSearcher, AdjustmentsReportProvider> {
    @Override
    protected AdjustmentsReportSearcher createSearchFilter() {
        return new AdjustmentsReportSearcher(PriceAdjustmentDirection.SURCHARGE);
    }

    @Override
    protected AdjustmentsReportProvider createReportProvider(AdjustmentsReportSearcher yourSearcher) {
        try {
            return new UserAdjustmentsReportProvider(yourSearcher, "Surcharges Report by User", AdjustmentsReport.Properties.USER_NAME);
        }
        catch (BuilderException ex) {
            OrderMate.LOG.error("Cannot build a user Surcharges Report", (Throwable)ex);
            return null;
        }
    }
}

