/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.categorytotal;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.Price;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.TradingDay;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="report_daily_cat_total")
public class CategoryTotalReport
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Price total;
    private Double sold;
    private Date reportDate;
    private Reference<InventoryCategory> category;
    private Reference<TradingDay> tradingDay;

    public CategoryTotalReport() {
        this.category = this.createReference(CategoryTotalReport.Properties.CATEGORY);
        this.tradingDay = this.createReference(CategoryTotalReport.Properties.TRADING_DAY);
    }

    public CategoryTotalReport(TradingDay day, Price theTotal, Double numSold, InventoryCategory cat) {
        this.category = this.createReference(CategoryTotalReport.Properties.CATEGORY);
        this.tradingDay = this.createReference(CategoryTotalReport.Properties.TRADING_DAY);
        this.tradingDay.set(day);
        if (day != null) {
            this.reportDate = day.getDate();
        }
        this.total = theTotal;
        this.sold = numSold;
        this.category.set(cat);
    }

    public void addReport(CategoryTotalReport toAdd) {
        this.total = this.total.add(toAdd.total);
        this.sold = this.sold + toAdd.sold;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.0001")})
    @Column(name="total")
    public Price getTotal() {
        return this.total;
    }

    public void setTotal(Price total) {
        this.total = total;
    }

    @Column(name="report_date")
    @Temporal(value=TemporalType.DATE)
    public Date getReportDate() {
        return this.reportDate;
    }

    protected void setReportDate(Date value) {
        this.reportDate = value;
    }

    @Column(name="sold")
    public Double getSold() {
        return this.sold;
    }

    protected void setSold(Double value) {
        this.sold = value;
    }

    @JoinColumn(name="fk_inventory_category")
    @ManyToOne
    public InventoryCategory getCategory() {
        return this.category.get();
    }

    protected void setCategory(InventoryCategory value) {
        this.category.set(value);
    }

    @JoinColumn(name="fk_finance_trading_day")
    @ManyToOne
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static final class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Price> TOTAL;
        public PropertiedObject.Property<Double> SOLD;
        public PropertiedObject.Property<Date> REPORT_DATE;
        public PropertiedObject.Property<InventoryCategory> CATEGORY;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
    }
}

