/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.categorytotal;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.reports.categorytotal.CategoryTotalReport;
import ordermate.database.searchers.reports.CategoryReportSearcher;

public class CategoryTotalReportCreator {
    public List<CategoryTotalReport> getReportsForTradingDay(TradingDay day) {
        List<CategoryTotalReport> reports = PersistenceManager.getObjectList(CategoryTotalReport.class, Query.select(CategoryTotalReport.class).equals(CategoryTotalReport.Properties.TRADING_DAY, day).orderBy(CategoryTotalReport.Properties.ID).toString(), null);
        if (reports == null || reports.isEmpty()) {
            reports = this.generateReports(day);
        }
        return reports;
    }

    private List<CategoryTotalReport> generateReports(TradingDay day) {
        CategoryReportSearcher searcher = this.createCategoryReportSearcher();
        searcher.getTradingDayFilter().setSearchValue(day);
        List<CategorySalesReport> reports = searcher.search();
        ArrayList<CategoryTotalReport> totalReports = new ArrayList<CategoryTotalReport>();
        List<InventoryCategory> categories = this.getRequiredCategories();
        for (InventoryCategory category : categories) {
            boolean found = false;
            for (CategorySalesReport report : reports) {
                if (!category.getLabel().equals(report.getInventoryCategoryName())) continue;
                found = true;
            }
            if (found) continue;
            totalReports.add(new CategoryTotalReport(day, Price.ZERO_DOLLAR, 0.0, category));
        }
        for (CategorySalesReport report : reports) {
            totalReports.add(new CategoryTotalReport(day, report.getSalesValue(), report.getQuantitySold().doubleValue(), InventoryCategory.getCategoryForName(report.getInventoryCategoryName())));
        }
        return totalReports;
    }

    protected List<InventoryCategory> getRequiredCategories() {
        return InventoryCategory.getAllCategories();
    }

    protected CategoryReportSearcher createCategoryReportSearcher() {
        return new CategoryReportSearcher();
    }
}

