/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.closedacounts;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.reports.closedacounts.ClosedAccountsReport;
import ordermate.database.sales.Account;
import ordermate.database.searchers.sales.AccountSearcher;

public class ClosedAccountsReportCompiler {
    private AccountSearcher searcher;

    public ClosedAccountsReportCompiler(AccountSearcher yourSearcher) {
        this.searcher = yourSearcher;
        this.searcher.setAccountOpen(false);
    }

    public List<ClosedAccountsReport> compile() {
        ArrayList<ClosedAccountsReport> result = new ArrayList<ClosedAccountsReport>();
        List<Account> searchResults = this.searcher.search();
        for (Account account : searchResults) {
            ClosedAccountsReport report = new ClosedAccountsReport();
            report.setAccountId(account.getID());
            report.setCreationDate(DateTimeUtils.getDateMonthYearFormat().format(account.getCreationDateTime()));
            report.setCreationTime(DateTimeUtils.formatTimeForDisplay(account.getCreationDateTime()));
            this.setOpeningUser(account, report);
            this.setClosingUser(account, report);
            this.setAccountType(account, report);
            report.setDescription(account.getRendererLabel());
            this.setOrderSource(account, report);
            this.setVoucherActivity(account, report);
            this.setSavedTotal(account, report);
            this.setPaymentTypeTerminalCashDrawer(account, report);
            this.setCustomer(account, report);
            result.add(report);
        }
        return result;
    }

    private void setOpeningUser(Account account, ClosedAccountsReport report) {
        if (account.getOpeningUser() != null) {
            report.setOpeningUser(account.getOpeningUser().getName());
        }
    }

    private void setClosingUser(Account account, ClosedAccountsReport report) {
        if (account.getClosingUser() != null) {
            report.setClosingUser(account.getClosingUser().getName());
        }
    }

    private void setAccountType(Account account, ClosedAccountsReport report) {
        if (account.getAccountType() != null) {
            report.setAccountType(account.getAccountType().getLabel());
        }
    }

    private void setOrderSource(Account account, ClosedAccountsReport report) {
        report.setOrderSource(account.getSource());
    }

    private void setVoucherActivity(Account account, ClosedAccountsReport report) {
        List<GiftVoucherTransaction> vTxns = account.getVoucherTxns();
        if (vTxns != null && !vTxns.isEmpty()) {
            report.setVoucherActivity("Yes");
        } else {
            report.setVoucherActivity("No");
        }
    }

    private void setSavedTotal(Account account, ClosedAccountsReport report) {
        if (account.getSavedTotal() != null) {
            report.setSavedTotal(account.getSavedTotal().doubleValue());
        }
    }

    private void setPaymentTypeTerminalCashDrawer(Account account, ClosedAccountsReport report) {
        List<FinanceTransaction> transactions = account.getFinanceTransactions();
        if (transactions != null && !transactions.isEmpty()) {
            ArrayList<String> paymentTypes = new ArrayList<String>();
            for (FinanceTransaction ta : transactions) {
                if (!"ACTIVE".equals(ta.getSystemState()) || ta.getSubType() == null || paymentTypes.contains(ta.getSubType().getLabel())) continue;
                paymentTypes.add(ta.getSubType().getLabel());
            }
            report.setPaymentType(((Object)paymentTypes).toString());
            report.setTerminal(transactions.get(0).getTerminal().getLabel());
            report.setCashDrawer(transactions.get(0).getCashDrawer().getLabel());
        }
    }

    private void setCustomer(Account account, ClosedAccountsReport report) {
        if (account.getCustomer() != null) {
            report.setCustomer(account.getCustomer().getName());
        }
    }

    public AccountSearcher getSearcher() {
        return this.searcher;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false)
    public RangeQuerySearchFilter getDateRangeFilter() {
        return this.searcher.getDateRangeSearch();
    }
}

