/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.closedacounts;

import au.com.ordermate.reports.MakesReport;
import au.com.ordermate.reports.ReportConfigureColumnMetaData;
import ordermate.database.reports.closedacounts.ClosedAccountsReportCompiler;
import ordermate.database.reports.closedacounts.ClosedAccountsReportProvider;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.searchers.sales.AccountSearcher;

@MakesReport(value="Closed Accounts", description="A list of accounts that were opened today, that have since been finalised", category="Audit", columnMetaData={@ReportConfigureColumnMetaData(name="Date", grouped=1), @ReportConfigureColumnMetaData(name="Time", locked=true), @ReportConfigureColumnMetaData(name="Opened By", grouped=2), @ReportConfigureColumnMetaData(name="Closed By", grouped=3), @ReportConfigureColumnMetaData(name="Account Type", grouped=4), @ReportConfigureColumnMetaData(name="Order Source", grouped=6), @ReportConfigureColumnMetaData(name="Voucher Activity", grouped=5), @ReportConfigureColumnMetaData(name="Payment Type", grouped=7), @ReportConfigureColumnMetaData(name="Terminal", grouped=8), @ReportConfigureColumnMetaData(name="Cash Drawer", grouped=9), @ReportConfigureColumnMetaData(name="Total", totaled=true)}, permission="Closed Account Reports")
public class ClosedAccountsReportMaker
extends ConfigurableReportMaker<AccountSearcher, ClosedAccountsReportProvider> {
    @Override
    protected AccountSearcher createSearchFilter() {
        AccountSearcher searcher = new AccountSearcher();
        searcher.setAccountOpen(false);
        return searcher;
    }

    @Override
    protected ClosedAccountsReportProvider createReportProvider(AccountSearcher yourSearcher) {
        return new ClosedAccountsReportProvider(new ClosedAccountsReportCompiler(yourSearcher));
    }
}

