/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.closedacounts;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.util.Price;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.misc.SystemProperty;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.closedacounts.ClosedAccountsReport;
import ordermate.database.reports.closedacounts.ClosedAccountsReportCompiler;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class ClosedAccountsReportProvider
extends AbstractReportProvider {
    private final ClosedAccountsReportCompiler compiler;

    public ClosedAccountsReportProvider(ClosedAccountsReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.compile());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Closed Account Report");
        builder.setSubtitle(this.createSubtitle());
        if (SystemProperty.getInstance().isShowAccId()) {
            builder.addReportColumn(ClosedAccountsReport.Properties.ACCOUNT_ID, "Receipt #", "0");
        }
        builder.addReportColumn(ClosedAccountsReport.Properties.CREATION_DATE, "Date", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.CREATION_TIME, "Time", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.OPENING_USER, "Opened By", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.CLOSING_USER, "Closed By", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.ACCOUNT_TYPE, "Account Type", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.DESCRIPTION, "Description", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.ORDER_SOURCE, "Order Source", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.VOUCHER_ACTIVITY, "Voucher Activity", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.SAVED_TOTAL, "Total", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(ClosedAccountsReport.Properties.PAYMENT_TYPE, "Payment Type", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.CUSTOMER, "Customer", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.TERMINAL, "Terminal", null);
        builder.addReportColumn(ClosedAccountsReport.Properties.CASH_DRAWER, "Cash Drawer", null);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(ClosedAccountsReport.Properties.SAVED_TOTAL), Price.class, DJCalculation.SUM);
        builder.getStyles().getFooterVariableStyle().setFont(Font.ARIAL_SMALL_BOLD);
        builder.getReportBuilder().setGrandTotalLegend("Total");
        builder.getReportBuilder().setGrandTotalLegendStyle(builder.getStyles().getFooterVariableStyle());
        return builder;
    }

    private String createSubtitle() {
        AccountSearcher searcher = this.compiler.getSearcher();
        StringBuilder SB = new StringBuilder();
        ReportProviderHelper helper = this.getHelper();
        helper.appendDatedSubtitle(SB, searcher.getDateRangeSearch(), searcher.getTimeRangeSearch());
        helper.appendSearchFilter(SB, "Account ID", searcher.getIDSearch());
        helper.appendRangeSearchFilter(SB, "Date Due", searcher.getDateDueRangeSearch(), helper.getDateFormat());
        helper.appendRangeSearchFilter(SB, "Time Due", searcher.getTimeDueSearch(), helper.getTimeFormat());
        helper.appendSearchFilter(SB, "Opened by", searcher.getOpenedByUser());
        helper.appendSearchFilter(SB, "Closed by", searcher.getClosedByUser());
        helper.appendSearchFilter(SB, "Customer", searcher.getCustomerSearch());
        helper.appendSearchFilter(SB, "Customers", searcher.getMultiCustomerSearch());
        helper.appendSearchFilter(SB, "Account State", searcher.getAccountStateSearch());
        helper.appendSearchFilter(SB, "Receipt State", searcher.getReceiptPrintStateSearch());
        helper.appendSearchFilter(SB, "Shift", searcher.getFinanceShiftSearch());
        helper.appendSearchFilter(SB, "Shift Name", searcher.getShiftNameSearch());
        helper.appendRangeSearchFilter(SB, "Amount", searcher.getFinanceTransactionAmountRangeSearch(), null);
        helper.appendRangeSearchFilter(SB, "Total", searcher.getSavedTotalSearch(), null);
        helper.appendSearchFilter(SB, "Unit", searcher.getPaymentTypeSearch());
        helper.appendSearchFilter(SB, "Terminal", searcher.getTerminalSearch());
        helper.appendSearchFilter(SB, "Paid Off", searcher.getPayOffDayFilter());
        helper.appendSearchFilter(SB, "Driver", searcher.getDeliveryDriverSearch());
        helper.appendSearchFilter(SB, "Source", searcher.getOrderSourceListSearch());
        helper.appendSearchFilter(SB, "Account Type", searcher.getAccountTypeListSearch());
        helper.appendSearchFilter(SB, "Sales Location", searcher.getSalesLocationFilter());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

