/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.cogs;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.cogs.COGSReport;
import ordermate.database.reports.cogs.COGSReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class COGSReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<COGSReportSearcher> dataProvider;
    private COGSReportSearcher searcher;
    private boolean groupByGroup;
    private ReportBuilder.TemplateFormat orientation = ReportBuilder.TemplateFormat.A4Portrait;

    public COGSReportProvider(COGSReportSearcher theSearcher) {
        theSearcher.initWebFilter();
        this.searcher = theSearcher;
        this.dataProvider = new SearcherDataSourceProvider<COGSReportSearcher>(this.searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dataProvider.getDataSource();
    }

    @Override
    public DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(this.orientation);
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle(this.buildTitleString()).setSubtitle(this.buildSubtitleString());
        if (!this.groupByGroup) {
            builder.addReportColumn(COGSReport.Properties.GROUP, "Group", "");
        }
        builder.addReportColumn(COGSReport.Properties.ITEM_NAME, "Name", null).addReportColumn(COGSReport.Properties.SIZE, "Size", null).addReportColumn(COGSReport.Properties.PRICE_LEVEL, "Price Level", null).addReportColumn(COGSReport.Properties.QTY_SOLD, "Qty Sold", "0").addReportColumn(COGSReport.Properties.COGS, "Est. Cost", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00").addReportColumn(COGSReport.Properties.SALES_INC_TAX, "Sales Inc Tax", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00").addReportColumn(COGSReport.Properties.SALES_EX_TAX, "Sales Ex Tax", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00").addReportColumn(COGSReport.Properties.GROSS_PROFIT_PERCENT, "GP %", "#.##").addReportColumn(COGSReport.Properties.GROSS_PROFIT, "GP \\$", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        if (this.groupByGroup) {
            builder.addInvisibleField(COGSReport.Properties.GROUP).addGroupBy(COGSReport.Properties.GROUP, Arrays.asList(new ReportBuilder.PropertyCalculation(COGSReport.Properties.QTY_SOLD, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(COGSReport.Properties.COGS, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(COGSReport.Properties.SALES_INC_TAX, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(COGSReport.Properties.SALES_EX_TAX, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(COGSReport.Properties.GROSS_PROFIT_PERCENT, DJCalculation.AVERAGE), new ReportBuilder.PropertyCalculation(COGSReport.Properties.GROSS_PROFIT, DJCalculation.SUM)));
        }
        this.buildGrandTotalFooter(builder);
        this.adjustColumnWidths(builder);
        this.adjustTitleStyle(builder);
        this.adjustColumnHeaderStyle(builder);
        this.adjustFooterStyle(builder);
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Note: The date range being displayed has been adjusted to match your trading day start and end times.";
    }

    public void setSearcher(COGSReportSearcher newSearcher) {
        this.searcher = newSearcher;
        this.dataProvider = new SearcherDataSourceProvider<COGSReportSearcher>(this.searcher);
    }

    public COGSReportSearcher getSearcher() {
        return this.searcher;
    }

    public void setGrouped(boolean group) {
        this.groupByGroup = group;
    }

    public ReportBuilder.TemplateFormat togglePageOrientation() {
        this.orientation = this.orientation.equals((Object)ReportBuilder.TemplateFormat.A4Portrait) ? ReportBuilder.TemplateFormat.A4Landscape : ReportBuilder.TemplateFormat.A4Portrait;
        return this.orientation;
    }

    private void buildGrandTotalFooter(ReportBuilder builder) {
        Style style = builder.getStyles().getFooterVariableStyle();
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.QTY_SOLD), BigDecimal.class, DJCalculation.SUM, style);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.COGS), Price.class, DJCalculation.SUM, style);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.SALES_INC_TAX), Price.class, DJCalculation.SUM, style);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.SALES_EX_TAX), Price.class, DJCalculation.SUM, style);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.GROSS_PROFIT_PERCENT), Double.class, DJCalculation.AVERAGE, style);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(COGSReport.Properties.GROSS_PROFIT), Price.class, DJCalculation.SUM, style);
    }

    private void adjustColumnWidths(ReportBuilder builder) {
        PropertyColumn itemName = builder.getPropertyColumn(COGSReport.Properties.ITEM_NAME);
        itemName.setWidth(Integer.valueOf(itemName.getWidth() + 40));
        PropertyColumn itemSize = builder.getPropertyColumn(COGSReport.Properties.SIZE);
        itemSize.setWidth(Integer.valueOf(itemSize.getWidth() - 10));
        PropertyColumn qtySold = builder.getPropertyColumn(COGSReport.Properties.QTY_SOLD);
        qtySold.setWidth(Integer.valueOf(qtySold.getWidth() - 10));
        PropertyColumn gpValue = builder.getPropertyColumn(COGSReport.Properties.GROSS_PROFIT);
        gpValue.setWidth(Integer.valueOf(gpValue.getWidth() - 10));
        PropertyColumn gpPercent = builder.getPropertyColumn(COGSReport.Properties.GROSS_PROFIT_PERCENT);
        gpPercent.setWidth(Integer.valueOf(gpPercent.getWidth() - 10));
    }

    private void adjustTitleStyle(ReportBuilder builder) {
        Font titleFont = builder.getStyles().getTitleStyle().getFont();
        titleFont.setFontSize(titleFont.getFontSize() - 4);
        titleFont.setBold(true);
        builder.getStyles().getTitleStyle().setFont(titleFont);
    }

    private void adjustColumnHeaderStyle(ReportBuilder builder) {
        Font headerFont = builder.getStyles().getColumnHeaderStyle().getFont();
        headerFont.setFontSize(headerFont.getFontSize() - 2);
        headerFont.setBold(true);
        builder.getStyles().getColumnHeaderStyle().setFont(headerFont);
    }

    private void adjustFooterStyle(ReportBuilder builder) {
        builder.getStyles().getFooterVariableStyle().setFont(Font.ARIAL_SMALL_BOLD);
        builder.getStyles().getFooterVariableStyle().setBorderTop(Border.PEN_1_POINT);
        builder.setUseGrandTotal(true);
        builder.getReportBuilder().setGrandTotalLegend("Grand Total");
        builder.getReportBuilder().setGrandTotalLegendStyle(builder.getStyles().getFooterVariableStyle());
    }

    private String buildTitleString() {
        String reportTitle = "Cost of Goods Sold Report";
        if (this.searcher.getDateRangeFilter().getStart() == null) {
            return reportTitle;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        return reportTitle + " " + format.format(this.searcher.getDateRangeFilter().getStart()) + " to " + format.format(this.searcher.getDateRangeFilter().getEnd());
    }

    private String buildSubtitleString() {
        String profile = this.searcher.getProfileFilter().getSearchValue() == null ? "All" : this.searcher.getProfileFilter().getSearchValue().getLabel();
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSubTitleAndValue(SB, "Profile", profile);
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Section", this.searcher.getGroupFilter());
        this.getHelper().appendCollection(SB, "Sales Location", this.searcher.getSalesLocationFilter().getSelectedOptions());
        if (Boolean.TRUE.equals(this.searcher.getShowUnsoldFilter().getSearchValue())) {
            SB.append("\\nShowing unsold");
        }
        return SB.toString();
    }
}

