/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.cogs;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import java.sql.Timestamp;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.finance.Shift;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.cogs.COGSReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class COGSReportSearcher
extends PropertySearcher<COGSReport> {
    private final ISingleValueSearchFilter<InventoryProfile> profileFilter;
    private final ISingleValueSearchFilter<InventoryGroup> groupFilter;
    private final MultiOptionJoinSearchFilter<ConfigShift> shiftFilter;
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private final ISingleValueSearchFilter<Boolean> showUnsoldFilter;
    private Timestamp sqlFrom;
    private Timestamp sqlTo;

    public COGSReportSearcher() {
        super(COGSReport.class);
        this.profileFilter = new ObjectSearchFilter<InventoryProfile>(InventoryGroup.Properties.PROFILE);
        this.groupFilter = new ObjectSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.shiftFilter = new MultiOptionJoinSearchFilter(Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SalesItemQuantity.Properties.CREATION_TIME, SQLDateType.TIMESTAMP);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.showUnsoldFilter = new BooleanSearchFilter(null);
        this.addSearchFilter(this.profileFilter);
        this.addSearchFilter(this.groupFilter);
        this.addSearchFilter(this.shiftFilter);
        this.addSearchFilter(this.salesLocationFilter);
        this.showUnsoldFilter.setSearchValue(Boolean.FALSE);
    }

    public void initWebFilter() {
        if (this.dateRangeFilter.hasSearchValue()) {
            this.sqlFrom = new Timestamp(((Date)this.dateRangeFilter.getStart()).getTime() / 1000L * 1000L);
            this.sqlTo = new Timestamp(((Date)this.dateRangeFilter.getEnd()).getTime() / 1000L * 1000L);
        }
    }

    @FilterConfig(name="Date Range", plural=FilterConfig.Plural.Ranged, dataType=Date.class, nullAllowed=false, dateType=SQLDateType.DATE, priority=true, sequence=1)
    public IRangedSearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    public ISingleValueSearchFilter<InventoryProfile> getProfileFilter() {
        return this.profileFilter;
    }

    @FilterConfig(name="Section", plural=FilterConfig.Plural.Single, dataType=InventoryGroup.class, nullAllowed=true, priority=true, sequence=3)
    public ISingleValueSearchFilter<InventoryGroup> getGroupFilter() {
        return this.groupFilter;
    }

    @FilterConfig(name="Shift", plural=FilterConfig.Plural.Multiple, dataType=ConfigShift.class, nullAllowed=true, priority=true, sequence=4)
    public MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        return this.shiftFilter;
    }

    @FilterConfig(name="Show Unsold", plural=FilterConfig.Plural.Single, dataType=Boolean.class, nullAllowed=false, priority=true, sequence=2)
    public ISingleValueSearchFilter<Boolean> getShowUnsoldFilter() {
        return this.showUnsoldFilter;
    }

    @FilterConfig(name="Sales Location", plural=FilterConfig.Plural.Multiple, dataType=SalesLocation.class, nullAllowed=true, sequence=10)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public boolean isShowUnsold() {
        return this.showUnsoldFilter.getSearchValue();
    }

    public void setShowUnsold(boolean showUnsold) {
        this.showUnsoldFilter.setSearchValue(showUnsold);
    }

    @Override
    public boolean hasSearchValues() {
        return this.sqlFrom != null && this.sqlTo != null;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(InventoryItem.Properties.LABEL).select(InventoryItemUnit.Properties.ID).select(InventoryItemUnit.Properties.SYSTEM_STATE).select(InventoryItemSize.Properties.LABEL).select(InventoryItemPortion.Properties.LABEL).select(InventoryGroup.Properties.LABEL).select(PriceLevel.Properties.LABEL).sum(SalesItemQuantity.Properties.QUANTITY, "QtySold").sumMultiplication(SalesComponent.Properties.INGREDIENT_COST_EX_TAX, SalesItemQuantity.Properties.QUANTITY, "COGS").sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, "Sales").selectFunc("SUM((" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + " - " + SalesComponent.Properties.INGREDIENT_COST_EX_TAX + ") * " + SalesItemQuantity.Properties.QUANTITY + ") AS GPValue").selectFunc("SUM((" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + " - " + SalesComponent.Properties.INGREDIENT_COST_EX_TAX + ") * " + SalesItemQuantity.Properties.QUANTITY + ") * 100 / SUM((" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + ") * " + SalesItemQuantity.Properties.QUANTITY + ") AS GPPercent").selectFunc("SUM((" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + ") * " + SalesItemQuantity.Properties.QUANTITY + ") AS SalesExTax").from("inventory_item_unit", null).linkUsing(InventoryItemUnit.Properties.SIZE, InventoryItemSize.Properties.ID).linkUsing(InventoryItemUnit.Properties.PORTION, InventoryItemPortion.Properties.ID).linkUsing(InventoryItemUnit.Properties.ITEM, InventoryItem.Properties.ID).linkUsing(InventoryItem.Properties.MENU_GROUP, InventoryGroup.Properties.ID);
        if (!Boolean.TRUE.equals(this.showUnsoldFilter.getSearchValue())) {
            query.havingFunction("QtySold > 0");
            query.linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(SalesComponent.Properties.PRICE_LEVEL, PriceLevel.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).joinFunction("JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item_quantity.creation_time >= '" + this.sqlFrom + "' AND sales_item_quantity.creation_time <= '" + this.sqlTo + "' ", SalesItemQuantity.class);
        } else {
            query.havingFunction("QtySold > 0 OR inventory_item_unit.system_state = 'ACTIVE'");
            query.joinLeft(SalesComponent.class, SalesComponent.Properties.UNIT).joinLeft(PriceLevel.class, SalesComponent.Properties.PRICE_LEVEL).joinLeft(SalesItem.class, SalesComponent.Properties.SALES_ITEM).joinFunction("LEFT JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item_quantity.creation_time >= '" + this.sqlFrom + "' AND sales_item_quantity.creation_time <= '" + this.sqlTo + "' ", SalesItemQuantity.class).lastFrom("inventory_item_unit");
        }
        if (this.getShiftFilter().hasSearchValue()) {
            query.linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(Account.Properties.SHIFT, Shift.Properties.ID).linkUsing(Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        }
        query.groupBy(InventoryItemUnit.Properties.ID);
        query.orderBy(InventoryGroup.Properties.LABEL).orderBy(InventoryItem.Properties.LABEL, false);
        return query;
    }
}

