/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.combos;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.persistence.PersistenceManager;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.reports.InventoryComboSoldReport;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.general.ComboSoldReport;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.database.searchers.reports.sales.general.ComboSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.reports.impl.OrdermateReportTemplateProvider;
import ordermate.reports.printing.HeaderSubReport;

public class ComboSoldReportProvider
extends OrdermateReportTemplateProvider<ComboSoldReport>
implements ReportProvider {
    private static final String COMBOS_REPORT_TEMPLATE = "/ordermate/reports/printing/ComboSoldReport.jrxml";
    public static final String COMBO_COUNT_PARAM = "invComboCount";
    private static final String KEY_DOLLAR_SIGN = "dollarSign";
    private ComboSoldReportSearcher comboSearcher;
    private ReportBuilder builder;
    private ReportBuilder builderWithCOGS;
    private User user;
    private boolean showCOGS = true;
    public static final String COMBO_NAME = "Combo Name";
    public static final String COMBO_TYPE = "Combo Type";
    public static final String ITEM_NAME = "Item Name";
    public static final String ITEM_SIZE = "Item Size";
    public static final String PORTION = "Item Portion";
    public static final String ITEMS_SOLD = "Items Sold";
    public static final String UNIT_PRICE = "Unit Price";
    public static final String MENU_PRICE = "Menu Price";
    public static final String DISCOUNT = "Discount";
    public static final String COGS = "COGS";
    public static final String COGS_PERCENTAGE = "COGS Percentage";
    private List<ComboSoldReport> currentReportItems;

    public ComboSoldReportProvider(ComboSoldReportSearcher searcher) {
        super(COMBOS_REPORT_TEMPLATE, searcher, searcher.getPeriod());
        this.comboSearcher = searcher;
    }

    @Override
    public String getReportTitle() {
        return "Combos Sold Report";
    }

    @Override
    public TimeSearchFilter getTimeFilter() {
        return ((ComboSoldReportSearcher)this.getSearcher()).getTimeFilter();
    }

    @Override
    public Map<String, Object> injectParameters() {
        List<InventoryComboSoldReport> comboCounts = PersistenceManager.getObjectList(this.comboSearcher.createInventoryComboSearcher());
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(comboCounts.size());
        for (InventoryComboSoldReport report : comboCounts) {
            map.put(report.getInventoryCombo().getID(), report.getCountSold().getValue());
        }
        this.addParam(COMBO_COUNT_PARAM, map);
        this.addReportParam(KEY_DOLLAR_SIGN, Internationalization.getLiteralFor("DOLLAR_SIGN"));
        return super.injectParameters();
    }

    @Override
    protected String getSubTitle() {
        ReportProviderHelper helper = new ReportProviderHelper();
        StringBuilder SB = new StringBuilder(this.getDateString());
        TimeSearchFilter timeFilter = this.getTimeFilter();
        if (timeFilter != null) {
            String time = timeFilter.getDisplayableTime();
            helper.appendSubTitleAndValue(SB, "Day Part", time);
        }
        helper.appendSearchFilter(SB, "Menu Section", this.comboSearcher.getMenuSectionFilter());
        helper.appendSearchFilter(SB, "Terminal", this.comboSearcher.getTerminalFilter());
        helper.appendSearchFilter(SB, "Shift", this.comboSearcher.getShiftFilter());
        helper.appendSearchFilter(SB, "Combos", this.comboSearcher.getComboFilter());
        helper.appendSearchFilter(SB, "Profile", this.comboSearcher.getProfileFilter());
        helper.appendSearchFilter(SB, "User", this.comboSearcher.getUserFilter());
        helper.appendSearchFilter(SB, "Sales Location", this.comboSearcher.getSalesLocationFilter());
        return SB.toString().replace("\\n", "\n");
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.comboSearcher.getTradingDayDateRangeFilter());
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null || this.builder.getColumnCount() == 0) {
            this.builder = new ReportBuilder();
            this.initBuilder(this.builder);
        }
        if (this.builderWithCOGS == null || this.builderWithCOGS.getColumnCount() == 0) {
            this.builderWithCOGS = new ReportBuilder();
            this.initBuilder(this.builderWithCOGS);
        }
        if (this.showCOGS) {
            return this.builderWithCOGS;
        }
        return this.builder;
    }

    private synchronized void initBuilder(ReportBuilder toInitialise) throws BuilderException {
        toInitialise.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        toInitialise.setTitle(this.getReportTitle());
        toInitialise.setSubtitle(this.getSubTitle());
        this.addReportColumns(toInitialise);
        toInitialise.getPropertyColumn(ComboSoldReport.Properties.UNIT_PRICE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        toInitialise.getPropertyColumn(ComboSoldReport.Properties.MENU_PRICE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        toInitialise.getPropertyColumn(ComboSoldReport.Properties.DISCOUNT).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        toInitialise.getPropertyColumn(ComboSoldReport.Properties.COGS).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        toInitialise.getPropertyColumn(ComboSoldReport.Properties.ITEMS_SOLD).setPattern("0");
    }

    protected void addReportColumns(ReportBuilder toInitialise) throws BuilderException {
        toInitialise.addReportColumns(Arrays.asList(ComboSoldReport.Properties.COMBO_NAME, ComboSoldReport.Properties.COMBO_TYPE, ComboSoldReport.Properties.ITEM_NAME, ComboSoldReport.Properties.ITEM_SIZE, ComboSoldReport.Properties.PORTION, ComboSoldReport.Properties.ITEMS_SOLD, ComboSoldReport.Properties.UNIT_PRICE, ComboSoldReport.Properties.MENU_PRICE, ComboSoldReport.Properties.DISCOUNT, ComboSoldReport.Properties.COGS, ComboSoldReport.Properties.COGS_PERCENTAGE), COMBO_NAME, COMBO_TYPE, ITEM_NAME, ITEM_SIZE, PORTION, ITEMS_SOLD, UNIT_PRICE, MENU_PRICE, DISCOUNT, COGS, COGS_PERCENTAGE);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.currentReportItems = this.comboSearcher.search();
        return new JRBeanCollectionDataSource(this.currentReportItems);
    }

    public void setShowCOGS(boolean showCOGS) {
        this.showCOGS = showCOGS;
    }
}

