/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config;

import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.search.Searcher;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public abstract class AbstractBaseReportCompiler
implements BaseReportCompiler {
    private static final String ALL = "ALL";
    private PeriodReportAdapter adapter = PeriodReportAdapter.WEEK_ENDING;
    private Date reportDate;
    private BaseReportGrouping grouping;
    protected String subType;
    protected List<CustomReportQueryPart> queryParts = Collections.emptyList();
    protected Collection<String> restrictedColumns = Collections.emptyList();

    @Override
    public void setSubType(String value) {
        this.subType = value;
        if (value != null && value.trim().isEmpty()) {
            this.subType = null;
        }
    }

    @Override
    public void setPeriod(PeriodReportAdapter adapter) {
        this.adapter = adapter;
    }

    protected PeriodReportAdapter getAdapter() {
        return this.adapter;
    }

    protected List<String> getExtraSelects() {
        ArrayList<String> extras = new ArrayList<String>();
        for (CustomReportQueryPart part : this.queryParts) {
            if (!QueryPart.SELECT.equals((Object)part.getPartType()) || !part.getBaseReport().equals((Object)this.getBaseReport()) || !this.matchesSubType(part.getSubType())) continue;
            extras.add(part.getColName());
        }
        return extras;
    }

    private boolean matchesSubType(String toMatch) {
        if (this.subType == null && (StringUtils.isEmpty(toMatch) || ALL.equals(toMatch))) {
            return true;
        }
        return this.subType != null && (ALL.equals(toMatch) || this.subType.equals(toMatch));
    }

    protected List<String> getExtraGroups() {
        ArrayList<String> extras = new ArrayList<String>();
        for (CustomReportQueryPart part : this.queryParts) {
            if (!QueryPart.GROUP.equals((Object)part.getPartType()) || part.getBaseReport() != null && !part.getBaseReport().equals((Object)this.getBaseReport()) || !this.matchesSubType(part.getSubType())) continue;
            extras.add(part.getPartText() + "." + part.getColName());
        }
        return extras;
    }

    @Override
    public void setDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    protected Date getStartDate() {
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.adapter)) {
            return DateTimeUtils.clearTimePart(this.getEnd());
        }
        Date pointWithinRage = this.reportDate != null ? this.reportDate : new Date();
        return this.adapter.getDateOffset().calcStart(pointWithinRage);
    }

    protected Date getEndDate() {
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.adapter)) {
            return this.adapter.getDateOffset().calcStart(this.reportDate);
        }
        return this.getEnd();
    }

    private Date getEnd() {
        Calendar cal = Calendar.getInstance();
        Date pointWithinRange = this.reportDate != null ? this.reportDate : new Date();
        cal.setTime(this.adapter.getDateOffset().calcEnd(this.adapter.getDateOffset().calcStart(pointWithinRange)));
        if (!PeriodReportAdapter.WEEK_ENDING.equals(this.adapter)) {
            cal.add(14, -1);
        }
        return cal.getTime();
    }

    protected Date getPreviousStart() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getStartDate());
        cal.add(14, -1);
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.adapter)) {
            cal.setTime(this.getStartDate());
            cal.add(5, -1);
            return this.adapter.getDateOffset().calcEnd(cal.getTime());
        }
        return this.adapter.getDateOffset().calcStart(cal.getTime());
    }

    protected Date getPreviousEnd() {
        Calendar cal = Calendar.getInstance();
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.adapter)) {
            cal.setTime(this.getStartDate());
            cal.add(14, -1);
            return this.adapter.getDateOffset().calcStart(cal.getTime());
        }
        cal.setTime(this.getPreviousStart());
        cal.add(14, -1);
        return this.adapter.getDateOffset().calcEnd(cal.getTime());
    }

    protected Date getLastYearStart() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getStartDate());
        cal.add(1, -1);
        return cal.getTime();
    }

    protected Date getLastYearEnd() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getEndDate());
        cal.add(1, -1);
        return cal.getTime();
    }

    protected Date getReportDate() {
        return this.reportDate;
    }

    @Override
    public void setGrouping(BaseReportGrouping grouping) {
        this.grouping = grouping;
    }

    protected BaseReportGrouping getGrouping() {
        if (this.grouping == null) {
            return BaseReportGrouping.None;
        }
        return this.grouping;
    }

    protected abstract Searcher createSearcher();

    public String getSampleSQL() {
        Searcher searcher = this.createSearcher();
        if (searcher instanceof ObjectQuerySearcher) {
            return ((ObjectQuerySearcher)searcher).getObjectQuery().toString();
        }
        return null;
    }

    @Override
    public void applyQueryPart(List<CustomReportQueryPart> parts) {
        this.queryParts = parts == null ? Collections.EMPTY_LIST : parts;
    }

    @Override
    public void applyColumnRestriction(Collection<String> reqCols) {
        this.restrictedColumns = reqCols == null ? Collections.EMPTY_SET : reqCols;
    }
}

