/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config;

import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.persistence.ArrayObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.searchers.ArrayObjectSearcher;

public abstract class ArrayObjectReportCompiler<T extends ArrayObjectSearcher>
extends AbstractBaseReportCompiler {
    protected T searcher = this.createSearcher();
    private Map<String, Integer> columnMap;
    private Map<Object, ArrayObject> resultMap;

    protected T getSearcher() {
        if (this.searcher == null) {
            this.searcher = this.createSearcher();
            this.applyFilters();
            this.applyMods();
            this.applyGrouping();
        }
        return this.searcher;
    }

    protected abstract T createSearcher();

    @Override
    public void compile() {
        this.searcher = this.createSearcher();
        this.applyFilters();
        this.applyMods();
        this.applyGrouping();
        this.applyRestrictions();
        this.primeIndexMap();
        this.runReport();
    }

    protected abstract void applyFilters();

    protected void applyMods() {
        ((ArrayObjectSearcher)this.getSearcher()).setQueryModifiers(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
    }

    protected void applyRestrictions() {
        ((ArrayObjectSearcher)this.getSearcher()).setSelectRestrictions(this.restrictedColumns);
    }

    protected void applyGrouping() {
        if (BaseReportGrouping.TradingDay.equals((Object)this.getGrouping())) {
            ((ArrayObjectSearcher)this.getSearcher()).setGroupBy(TradingDay.Properties.DATE);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.getGrouping())) {
            ((ArrayObjectSearcher)this.getSearcher()).setGroupBy(SalesLocation.Properties.ID);
        } else {
            ((ArrayObjectSearcher)this.getSearcher()).setGroupBy(null);
        }
    }

    protected void primeIndexMap() {
        this.columnMap = ((ArrayObjectSearcher)this.getSearcher()).mapPossibleColumns();
        int highest = 0;
        for (Integer next : this.columnMap.values()) {
            if (next == null || highest >= next) continue;
            highest = next;
        }
        int index = highest + 1;
        for (CustomReportQueryPart part : this.queryParts) {
            if (part.getBaseReport() != null && !part.getBaseReport().equals((Object)this.getBaseReport())) continue;
            if (QueryPart.SELECT.equals((Object)part.getPartType())) {
                this.columnMap.put(part.getColName(), index);
                ++index;
                continue;
            }
            if (!QueryPart.GROUP.equals((Object)part.getPartType())) continue;
            ++index;
        }
    }

    protected void runReport() {
        List<ArrayObject> objects = ((ArrayObjectSearcher)this.getSearcher()).search();
        this.resultMap = new LinkedHashMap<Object, ArrayObject>();
        for (ArrayObject obj : objects) {
            this.resultMap.put(obj.getIdentifier(), obj);
        }
    }

    @Override
    public Object getValue(Object rowId, String column) {
        if (this.columnMap.containsKey(column) && this.resultMap.containsKey(rowId)) {
            return this.resultMap.get(rowId).getArray()[this.columnMap.get(column)];
        }
        return null;
    }

    @Override
    public Set getRowIdentifiers() {
        return this.resultMap.keySet();
    }

    public ArrayObject getArrayObject(Object rowID) {
        return rowID != null ? this.resultMap.get(rowID) : null;
    }

    @Override
    public String getSampleSQL() {
        this.searcher = null;
        return ((ArrayObjectSearcher)this.getSearcher()).getObjectQuery().toString();
    }
}

