/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.database.misc.DayPart;
import ordermate.database.searchers.ArrayObjectSearcher;

public abstract class DynamicColumnSearcher
extends ArrayObjectSearcher {
    public static final String TOTAL_PREFIX = "_total";
    public static final String TOTAL_EX_PREFIX = "_total_ex";
    public static final String COUNT_PREFIX = "_count";
    public static final String TAX_PREFIX = "_tax";
    public static final String TOTAL_DISCOUNT_PREFIX = "_total_discount";
    public static final String TOTAL_SURCHARGE_PREFIX = "_total_surcharge";
    private List<Pair<Object, String>> dynamicColumns;

    @Override
    protected void initColumns() {
        super.initColumns();
        List<Pair<Object, String>> dyns = this.createDynamicColumns();
        if (dyns.size() > 0) {
            this.columns = new ArrayList(this.columns);
            this.dynamicColumns = new ArrayList<Pair<Object, String>>();
            for (Pair<Object, String> nextDynamicColumn : dyns) {
                this.columns.add(nextDynamicColumn.value);
                this.dynamicColumns.add(nextDynamicColumn);
            }
        }
    }

    protected List<Pair<Object, String>> getDynamicColumns() {
        return Collections.unmodifiableList(this.dynamicColumns);
    }

    protected List<Pair<Object, String>> createDynamicColumns() {
        ArrayList<Pair<Object, String>> dyns = new ArrayList<Pair<Object, String>>();
        if (!this.getColumnNamePairSQL().isEmpty()) {
            Object[][] ids;
            for (Object[] nextBatch : ids = PersistenceManager.getPersistenceDelegate().executeQuery(this.getColumnNamePairSQL(), new Object[0])) {
                this.addDynamicColumn(dyns, nextBatch[0], String.valueOf(nextBatch[1]));
            }
        }
        return dyns;
    }

    protected void addDynamicColumn(List<Pair<Object, String>> dynaCols, Object identifier, String columnLabel) {
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + TOTAL_PREFIX));
        dynaCols.add(new Pair<Object, String>(identifier, columnLabel + COUNT_PREFIX));
    }

    protected abstract String getColumnNamePairSQL();

    protected String getSelectDayPartQuery(String timeParam) {
        StringBuilder sb = new StringBuilder("(CASE ");
        List<DayPart> dayParts = DayPart.getAllDayPartsOrdered(true);
        for (DayPart part : dayParts) {
            sb.append("WHEN (TIME(").append(timeParam).append(") BETWEEN TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getStartTime())).append("') ").append("AND TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getEndTime())).append("') ").append(") THEN '").append(part.getLabel()).append("' ");
        }
        sb.append("ELSE '").append(dayParts.get(0).getLabel()).append("' END) AS day_part ");
        return sb.toString();
    }
}

