/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.adj;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class BaseAdjustmentSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseAdjustmentSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.count(SalesPriceAdjustmentUsage.class, "count_adj_use");
        query.selectFunc("COUNT(DISTINCT sales_price_adjustment.ID) as count_adj").select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day").selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT', saved_total_value, 0)) as `total_discounts`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT' AND sales_price_adjustment.level='Account Level', saved_total_value, 0)) as `account_discounts`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT' AND sales_price_adjustment.level='Item Level', saved_total_value, 0)) as `item_discounts`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE', saved_total_value, 0)) as `total_surcharges`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE' AND sales_price_adjustment.level='Account Level', saved_total_value, 0)) as `account_surcharges`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE' AND sales_price_adjustment.level='Item Level', saved_total_value, 0)) as `item_surcharges`").linkUsing(SalesPriceAdjustment.Properties.TERMINAL).linkUsing(Terminal.Properties.SALES_LOCATION).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT);
        StringBuilder notIn = new StringBuilder();
        List<Pair<Object, String>> dynamicCols = this.getDynamicColumns();
        for (Pair<Object, String> pair : dynamicCols) {
            notIn.append(pair.key).append(",");
        }
        if (notIn.length() > 0) {
            notIn.replace(notIn.length() - 1, notIn.length(), "");
        }
        query.selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT' AND fk_inventory_price_adjustment NOT IN(" + notIn.toString() + "), saved_total_value, 0)) as `unallocated_discount`");
        query.selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE' AND fk_inventory_price_adjustment NOT IN(" + notIn.toString() + "), saved_total_value, 0)) as `unallocated_surcharge`");
        for (Pair<Object, String> nextPair : dynamicCols) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("COUNT(DISTINCT CASE WHEN sales_price_adjustment.fk_inventory_price_adjustment = ");
                SB.append(nextPair.key).append(" THEN sales_price_adjustment.ID END) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(sales_price_adjustment.fk_inventory_price_adjustment = ");
            SB.append(nextPair.key).append(", saved_total_value, 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("count_adj_use", "count_adj", "location", "trading_day", "total_discounts", "account_discounts", "item_discounts", "total_surcharges", "account_surcharges", "item_surcharges", "unallocated_discount", "unallocated_surcharge");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM inventory_price_adjustment ipa where ipa.system_state = 'ACTIVE' AND name IS NOT NULL AND name <> '' AND type <> 'CUSTOM' ORDER BY ipa.direction, ipa.Name";
    }
}

