/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.adj;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;

public class BaseAdjustmentsByTypeSearcher
extends DynamicColumnSearcher {
    private final RangeQuerySearchFilter<Date> dayFilter;

    public BaseAdjustmentsByTypeSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.select(SalesPriceAdjustment.Properties.LABEL, "adj_name");
        query.selectFunc("COUNT(DISTINCT sales_price_adjustment.ID) as count_adj");
        query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("SUM(IF(sales_price_adjustment.direction = 'DISCOUNT', saved_total_value, 0)) as `total_discounts`").selectFunc("SUM(IF(sales_price_adjustment.direction = 'SURCHARGE', saved_total_value, 0)) as `total_surcharges`").select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day").linkUsing(SalesPriceAdjustment.Properties.TERMINAL).linkUsing(Terminal.Properties.SALES_LOCATION).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(InventoryItem.Properties.CATEGORY);
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("adj_name", "count_adj", "category_name", "total_discounts", "total_surcharges", "location", "trading_day");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "";
    }
}

