/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.adj;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.reports.AccountTotalsReportQuery;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.SalesItemQuantity;

public class BaseComboAdjustmentSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseComboAdjustmentSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = AccountTotalsReportQuery.getOpenPriceComboDiscounts("total_discount");
        query.linkUsing(SalesItemQuantity.Properties.TRADING_DAY);
        query.select(SalesItemQuantity.Properties.SALES_LOCATION, "location");
        query.select(SalesItemQuantity.Properties.TRADING_DAY, "trading_day");
        for (Pair<Object, String> nextPair : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(combo.fk_inventory_combo = ");
                SB.append(nextPair.key).append(", 1, 0)) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(combo.fk_inventory_combo = ");
            SB.append(nextPair.key).append(", sales_item_quantity.quantity * (sales_component.menu_price - sales_component.open_price), 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("ID", "total_discount", "location", "trading_day");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM inventory_combo combo where combo.system_state = 'ACTIVE' AND combo.type NOT IN ('SimpleCombo', 'SalesAdjustmentCombo', 'SalesItem') ORDER BY combo.name";
    }
}

