/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.cogs;

import au.com.ordermate.util.Price;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.cogs.DailyCogsReport;
import ordermate.database.reports.config.cogs.DailyCogsSearcher;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.column.direct.BaseReport;

public class BaseCogsCompiler
extends AbstractBaseReportCompiler {
    private Map<Object, DailyCogsReport> reportMap;

    @Override
    public void compile() {
        this.reportMap = new HashMap<Object, DailyCogsReport>();
        DailyCogsSearcher searcher = this.createSearcher();
        searcher.getDateRangeFilter().setStart(this.getStartDate());
        searcher.getDateRangeFilter().setEnd(this.getEndDate());
        searcher.setGrouping(this.getGrouping());
        List<DailyCogsReport> reportList = searcher.search();
        if (BaseReportGrouping.StoreId.equals((Object)this.getGrouping())) {
            this.groupByStore(this.reportMap, reportList);
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.getGrouping())) {
            this.groupByDate(this.reportMap, reportList);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.getGrouping())) {
            this.groupBySalesLocation(this.reportMap, reportList);
        } else {
            this.groupByNone(this.reportMap, reportList);
        }
    }

    @Override
    protected DailyCogsSearcher createSearcher() {
        DailyCogsSearcher searcher = new DailyCogsSearcher();
        searcher.setQueryMods(CustomReportQueryPart.createModifiers(this.queryParts, this.getBaseReport(), this.subType));
        return searcher;
    }

    protected void groupByStore(Map<Object, DailyCogsReport> theReportMap, List<DailyCogsReport> reports) {
        for (DailyCogsReport report : reports) {
            theReportMap.put(report.getPropertyValue(DailyCogsReport.Properties.STORE_ID), report);
        }
    }

    protected void groupByDate(Map<Object, DailyCogsReport> theReportMap, List<DailyCogsReport> reports) {
        for (DailyCogsReport report : reports) {
            theReportMap.put(report.getReportDate(), report);
        }
    }

    protected void groupBySalesLocation(Map<Object, DailyCogsReport> theReportMap, List<DailyCogsReport> reports) {
        for (DailyCogsReport report : reports) {
            theReportMap.put(report.getSalesLocation(), report);
        }
    }

    protected void groupByNone(Map<Object, DailyCogsReport> theReportMap, List<DailyCogsReport> reports) {
        theReportMap.put("Total", reports.get(0));
    }

    @Override
    public Object getValue(Object rowId, String column) {
        if (this.reportMap.containsKey(rowId)) {
            return this.reportMap.get(rowId).getCogs();
        }
        return Price.ZERO_DOLLAR;
    }

    @Override
    public List<String> getDirectColumns() {
        List<String> list = this.getExtraSelects();
        list.add("cogs");
        return list;
    }

    @Override
    public Set getRowIdentifiers() {
        return this.reportMap.keySet();
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.COGS;
    }
}

