/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.cogs;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.config.location.SalesLocation;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
public class DailyCogsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Price cogs = Price.ZERO_DOLLAR;
    private Reference<SalesLocation> salesLocation;
    private Date reportDate;

    public DailyCogsReport() {
        this.salesLocation = this.createReference(DailyCogsReport.Properties.SALES_LOCATION);
    }

    @Column(name="cogs")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getCogs() {
        return this.cogs;
    }

    protected void setCogs(Price value) {
        this.cogs = value;
    }

    @Column(name="report_date")
    @Temporal(value=TemporalType.DATE)
    public Date getReportDate() {
        return this.reportDate;
    }

    protected void setReportDate(Date value) {
        this.reportDate = value;
    }

    @ManyToOne(targetEntity=SalesLocation.class)
    @JoinColumn(name="fk_config_sales_location")
    public SalesLocation getSalesLocation() {
        return this.salesLocation.get();
    }

    protected void setSalesLocation(SalesLocation loc) {
        this.salesLocation.set(loc);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Price> COGS;
        public PropertiedObject.Property<SalesLocation> SALES_LOCATION;
        public PropertiedObject.Property<Date> REPORT_DATE;
    }
}

