/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.cogs;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.cogs.DailyCogsReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;

public class DailyCogsSearcher
extends PropertySearcher<DailyCogsReport> {
    private IRangedQuerySearchFilter<Date> dateRangeFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private BaseReportGrouping grouping;
    private MultiOptionJoinSearchFilter<String> shiftFilter;

    public DailyCogsSearcher() {
        super(DailyCogsReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.shiftFilter = new MultiOptionJoinSearchFilter(ConfigShift.getAllConfigShiftsNames(), Account.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.LABEL);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.shiftFilter);
    }

    public void setGrouping(BaseReportGrouping grouping) {
        this.grouping = grouping;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(Account.Properties.TRADING_DAY, "ID").sumMultiplication(SalesComponent.Properties.INGREDIENT_COST_EX_TAX, SalesItemQuantity.Properties.QUANTITY, "cogs").select(TradingDay.Properties.DATE, "report_date").select(SalesItemQuantity.Properties.SALES_LOCATION, "fk_config_sales_location").selectFunc("0 as mod_count").linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(Account.Properties.TRADING_DAY);
        if (BaseReportGrouping.TradingDay.equals((Object)this.grouping)) {
            query.groupBy(Account.Properties.TRADING_DAY);
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.grouping)) {
            query.groupBy(SalesItemQuantity.Properties.SALES_LOCATION);
        } else if (BaseReportGrouping.StoreId.equals((Object)this.grouping)) {
            query.groupBy(Account.Properties.STORE_ID);
        }
        return query;
    }

    public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        return this.dateRangeFilter;
    }
}

