/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.gui.FontAttributes;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReportFilter;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;

@Entity
@Table(name="report_custom")
public class CustomReport
extends PersistentObject
implements Saveable,
Sequenced {
    public static final Props Properties = new Props();
    private String title;
    private String subTitle;
    private boolean landscape;
    private boolean showTitle;
    private boolean showBanner;
    private boolean pageBreak;
    private String defaultPeriod;
    private String columnBorder = "Thin";
    private int sequence = 1;
    private BaseReportGrouping grouping;
    private int titleHeight = 14;
    private int headerHeight;
    private String headerRotation;
    private Reference<FontAttributes> titleFont;
    private Reference<FontAttributes> subtitleFont;
    private Reference<FontAttributes> columnHeaderFont;
    private Reference<FontAttributes> columnFont;
    private Reference<CustomReport> parent;
    private PersistentWriteableList<CustomReportColumn> columns;
    private PersistentWriteableList<CustomReportSeries> series;
    private PersistentWriteableList<CustomReport> subReports;
    private PersistentWriteableList<CustomReportFilter> filters;
    private PersistentWriteableList<CustomReportQueryPart> queryParts;
    private transient Map<String, CustomReportColumn> columnMap;
    private transient List<CustomReportColumn> sequencedColumns;

    @Deprecated
    public CustomReport() {
        this.titleFont = this.createReference(CustomReport.Properties.TITLE_FONT);
        this.subtitleFont = this.createReference(CustomReport.Properties.SUBTITLE_FONT);
        this.columnHeaderFont = this.createReference(CustomReport.Properties.COLUMN_HEADER_FONT);
        this.columnFont = this.createReference(CustomReport.Properties.COLUMN_FONT);
        this.parent = this.createReference(CustomReport.Properties.PARENT);
        this.columns = this.createWriteableList(CustomReport.Properties.COLUMNS);
        this.series = this.createWriteableList(CustomReport.Properties.SERIES);
        this.subReports = this.createWriteableList(CustomReport.Properties.SUB_REPORTS);
        this.filters = this.createWriteableList(CustomReport.Properties.FILTERS);
        this.queryParts = this.createWriteableList(CustomReport.Properties.QUERY_PARTS);
    }

    public CustomReport(CustomReport yourParent) {
        this.titleFont = this.createReference(CustomReport.Properties.TITLE_FONT);
        this.subtitleFont = this.createReference(CustomReport.Properties.SUBTITLE_FONT);
        this.columnHeaderFont = this.createReference(CustomReport.Properties.COLUMN_HEADER_FONT);
        this.columnFont = this.createReference(CustomReport.Properties.COLUMN_FONT);
        this.parent = this.createReference(CustomReport.Properties.PARENT);
        this.columns = this.createWriteableList(CustomReport.Properties.COLUMNS);
        this.series = this.createWriteableList(CustomReport.Properties.SERIES);
        this.subReports = this.createWriteableList(CustomReport.Properties.SUB_REPORTS);
        this.filters = this.createWriteableList(CustomReport.Properties.FILTERS);
        this.queryParts = this.createWriteableList(CustomReport.Properties.QUERY_PARTS);
        this.parent.set(yourParent);
    }

    public CustomReport(String title, CustomReport yourParent) {
        this.titleFont = this.createReference(CustomReport.Properties.TITLE_FONT);
        this.subtitleFont = this.createReference(CustomReport.Properties.SUBTITLE_FONT);
        this.columnHeaderFont = this.createReference(CustomReport.Properties.COLUMN_HEADER_FONT);
        this.columnFont = this.createReference(CustomReport.Properties.COLUMN_FONT);
        this.parent = this.createReference(CustomReport.Properties.PARENT);
        this.columns = this.createWriteableList(CustomReport.Properties.COLUMNS);
        this.series = this.createWriteableList(CustomReport.Properties.SERIES);
        this.subReports = this.createWriteableList(CustomReport.Properties.SUB_REPORTS);
        this.filters = this.createWriteableList(CustomReport.Properties.FILTERS);
        this.queryParts = this.createWriteableList(CustomReport.Properties.QUERY_PARTS);
        this.title = title;
        this.parent.set(yourParent);
        this.subTitle = "";
        this.landscape = true;
        this.showTitle = true;
        this.defaultPeriod = "Monthly";
        this.grouping = BaseReportGrouping.None;
        this.titleHeight = 14;
        this.headerHeight = 20;
        this.headerRotation = "None";
        CustomReportSeries newSeries = new CustomReportSeries(this);
        newSeries.setOrdering("001");
        this.addSeries(newSeries);
        DirectReportColumn col = new DirectReportColumn(this, "001");
        col.setBaseReport(BaseReport.Group);
        col.setBaseReportProperty("Id");
        col.setVisible(false);
        this.addColumn(col);
        col = new DirectReportColumn(this, "002");
        col.setBaseReport(BaseReport.Group);
        col.setBaseReportProperty("Label");
        this.addColumn(col);
    }

    @ManyToOne(targetEntity=CustomReport.class)
    @JoinColumn(name="fk_report_custom")
    public CustomReport getParent() {
        return this.parent.get();
    }

    protected void setParent(CustomReport yourParent) {
        this.parent.set(yourParent);
    }

    @Column(name="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    @Column(name="show_title")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean value) {
        this.showTitle = value;
    }

    @Column(name="page_break")
    public boolean isPageBreak() {
        return this.pageBreak;
    }

    public void setPageBreak(boolean value) {
        this.pageBreak = value;
    }

    @Column(name="subtitle")
    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String value) {
        this.subTitle = value;
    }

    @Column(name="landscape")
    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean value) {
        this.landscape = value;
    }

    @Column(name="title_height")
    public int getTitleHeight() {
        return this.titleHeight;
    }

    public void setTitleHeight(int value) {
        this.titleHeight = value;
    }

    @Column(name="header_height")
    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int value) {
        if (value > 0) {
            this.headerHeight = value;
        }
    }

    @Column(name="header_rotation")
    public String getHeaderRotation() {
        return this.headerRotation;
    }

    public void setHeaderRotation(String value) {
        this.headerRotation = value;
        if (this.headerRotation == null) {
            this.headerRotation = "None";
        }
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="default_period")
    public String getDefaultPeriod() {
        return this.defaultPeriod;
    }

    public void setDefaultPeriod(String value) {
        this.defaultPeriod = value;
    }

    @Column(name="grouping")
    @Enumerated(value=EnumType.STRING)
    public BaseReportGrouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(BaseReportGrouping value) {
        this.grouping = value != null ? value : BaseReportGrouping.None;
    }

    public CustomReportColumn addColumn(CustomReportColumn column) {
        if (column != null) {
            this.columns.add(column);
            this.initMap();
            this.columnMap.put(column.getUniqueKey(), column);
            this.sequencedColumns = null;
        }
        return column;
    }

    public void removeColumn(CustomReportColumn column) {
        if (column != null) {
            this.columns.remove(column);
            this.initMap();
            this.columnMap.remove(column.getUniqueKey());
            this.sequencedColumns = null;
        }
    }

    public boolean setKey(String newKey, CustomReportColumn column) {
        if (newKey == null) {
            return false;
        }
        String trimmedKey = newKey.trim().toLowerCase();
        if (trimmedKey.isEmpty()) {
            return false;
        }
        CustomReportColumn oldCol = this.getColumn(trimmedKey);
        if (oldCol != null && !oldCol.equals(column)) {
            return false;
        }
        this.initMap();
        if (oldCol != null) {
            this.columnMap.remove(oldCol.getUniqueKey());
        }
        this.columnMap.remove(column.getUniqueKey());
        column.setUniqueKey(trimmedKey);
        this.columnMap.put(trimmedKey, column);
        return true;
    }

    @Column(name="show_banner")
    public boolean isShowBanner() {
        return this.showBanner;
    }

    public void setShowBanner(boolean value) {
        this.showBanner = value;
    }

    @Column(name="column_border")
    public String getColumnBorder() {
        return this.columnBorder;
    }

    public void setColumnBorder(String value) {
        this.columnBorder = value;
    }

    @OneToMany(mappedBy="report", targetEntity=CustomReportColumn.class, cascade={CascadeType.ALL})
    public List<CustomReportColumn> getColumns() {
        return this.columns.getUnmodifiable();
    }

    protected void setColumns(List<CustomReportColumn> values) {
        this.columns = this.columns.clone();
        this.columns.set(values);
    }

    @OneToMany(mappedBy="report", targetEntity=CustomReportSeries.class, cascade={CascadeType.ALL})
    public List<CustomReportSeries> getSeries() {
        return this.series.getUnmodifiable();
    }

    protected void setSeries(List<CustomReportColumn> values) {
        this.series = this.series.clone();
        this.series.set(values);
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="fk_title_font_att")
    public FontAttributes getTitleFont() {
        if (this.titleFont.isNull()) {
            this.titleFont.set(new FontAttributes());
        }
        return this.titleFont.get();
    }

    protected void setTitleFont(FontAttributes att) {
        this.titleFont.set(att);
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="fk_subtitle_font_att")
    public FontAttributes getSubtitleFont() {
        if (this.subtitleFont.isNull()) {
            this.subtitleFont.set(new FontAttributes());
        }
        return this.subtitleFont.get();
    }

    protected void setSubtitleFont(FontAttributes att) {
        this.subtitleFont.set(att);
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="fk_column_header_font_att")
    public FontAttributes getColumnHeaderFont() {
        if (this.columnHeaderFont.isNull()) {
            this.columnHeaderFont.set(new FontAttributes());
        }
        return this.columnHeaderFont.get();
    }

    protected void setColumnHeaderFont(FontAttributes att) {
        this.columnHeaderFont.set(att);
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="fk_column_font_att")
    public FontAttributes getColumnFont() {
        if (this.columnFont.isNull()) {
            this.columnFont.set(new FontAttributes());
        }
        return this.columnFont.get();
    }

    protected void setColumnFont(FontAttributes att) {
        this.columnFont.set(att);
    }

    public CustomReportSeries addSeries(CustomReportSeries toAdd) {
        if (this.series != null) {
            this.series.add(toAdd);
        }
        return toAdd;
    }

    public void removeSeries(CustomReportSeries toRemove) {
        if (this.series != null) {
            this.series.remove(toRemove);
        }
    }

    @OneToMany(mappedBy="parent", targetEntity=CustomReport.class, cascade={CascadeType.ALL})
    public List<CustomReport> getSubReports() {
        return this.subReports;
    }

    protected void setSubReports(List<CustomReport> values) {
        this.subReports = this.subReports.clone();
        this.subReports.set(values);
    }

    public void addSubReport(CustomReport subReport) {
        if (subReport != null) {
            this.subReports.add(subReport);
        }
    }

    public void removeSubReport(CustomReport subReport) {
        this.subReports.remove(subReport);
    }

    public void addQueryPart(CustomReportQueryPart queryPart) {
        if (queryPart != null && !this.queryParts.contains(queryPart)) {
            this.queryParts.add(queryPart);
        }
    }

    public void removeQueryPart(CustomReportQueryPart toRemove) {
        this.queryParts.remove(toRemove);
    }

    @OneToMany(targetEntity=CustomReportQueryPart.class, mappedBy="parent", cascade={CascadeType.ALL})
    public List<CustomReportQueryPart> getQueryParts() {
        return this.queryParts;
    }

    protected void setQueryParts(List<CustomReportQueryPart> part) {
        this.queryParts = this.queryParts.clone();
        this.queryParts.set(part);
    }

    public CustomReportColumn getColumn(String key) {
        String lowerKey;
        if (this.columnMap == null) {
            this.initMap();
        }
        if (this.columnMap.containsKey(lowerKey = key.toLowerCase().trim())) {
            return this.columnMap.get(lowerKey);
        }
        this.initMap();
        return this.columnMap.get(lowerKey);
    }

    private void initMap() {
        this.columnMap = new HashMap<String, CustomReportColumn>();
        for (CustomReportColumn col : this.columns) {
            this.columnMap.put(col.getUniqueKey(), col);
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.sequencedColumns = null;
        this.titleFont.saveChild();
        this.subtitleFont.saveChild();
        this.columnHeaderFont.saveChild();
        this.columnFont.saveChild();
        PersistenceManager.save(this);
        this.series.saveChild();
        this.columns.saveChild();
        this.subReports.saveChild();
        this.queryParts.saveChild();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        this.titleFont.deleteChild();
        this.subtitleFont.deleteChild();
        this.columnHeaderFont.deleteChild();
        this.columnFont.deleteChild();
        this.series.deleteChild();
        this.columns.deleteChild();
        this.subReports.deleteChild();
        this.queryParts.deleteChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        return this.getTitle() == null ? "No Title" : this.getTitle();
    }

    @Transient
    public List<CustomReportColumn> getSequencedColumns() {
        if (this.sequencedColumns == null) {
            this.sequencedColumns = new ArrayList<CustomReportColumn>(this.getColumns());
            PropertyComparator comparator = new PropertyComparator((PropertiedObject.Property<? extends Comparable>)CustomReportColumn.Properties.SEQUENCE);
            Collections.sort(this.sequencedColumns, comparator);
        }
        return this.sequencedColumns;
    }

    public void columnsUpdated() {
        this.sequencedColumns = null;
    }

    public int compareTo(Object o) {
        return Sequenced.SequenceComparator.getInst().compare(this, o);
    }

    @Transient
    public Collection<String> getRequiredColumns() {
        HashSet<String> reqCols = new HashSet<String>();
        reqCols.add("id");
        for (CustomReportColumn col : this.getColumns()) {
            if (!CustomReportColumnType.Direct.equals((Object)col.getColumnType())) continue;
            reqCols.add(((DirectReportColumn)col).getBaseReportProperty());
        }
        for (CustomReportQueryPart part : this.queryParts) {
            if (QueryPart.GROUP.equals((Object)part.getPartType())) {
                reqCols.add(part.getPartText());
                continue;
            }
            if (!QueryPart.SELECT.equals((Object)part.getPartType())) continue;
            reqCols.add(part.getColName());
        }
        return reqCols;
    }

    @OneToMany(mappedBy="report", targetEntity=CustomReportFilter.class, cascade={CascadeType.ALL})
    public List<CustomReportFilter> getFilters() {
        return this.filters.getUnmodifiable();
    }

    protected void setFilters(List<CustomReportFilter> filters) {
        this.filters = this.filters.clone();
        this.filters.set(filters);
    }

    public void addFilter(CustomReportFilter toAdd) {
        this.filters.add(toAdd);
    }

    public void removeFilter(CustomReportFilter toRemove) {
        this.filters.remove(toRemove);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> TITLE;
        public PropertiedObject.Property<String> SUB_TITLE;
        public PropertiedObject.Property<String> DEFAULT_PERIOD;
        public PropertiedObject.Property LANDSCAPE;
        public PropertiedObject.Property<BaseReportGrouping> GROUPING;
        public PropertiedObject.Property<String> HEADER_ROTATION;
        public PropertiedObject.Property HEADER_HEIGHT;
        public PropertiedObject.Property TITLE_HEIGHT;
        public PropertiedObject.Property<String> COLUMN_BORDER;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property SHOW_TITLE;
        public PropertiedObject.Property<Boolean> SHOW_BANNER;
        public PropertiedObject.Property PAGE_BREAK;
        public PropertiedObject.Property<FontAttributes> TITLE_FONT;
        public PropertiedObject.Property<FontAttributes> SUBTITLE_FONT;
        public PropertiedObject.Property<FontAttributes> COLUMN_HEADER_FONT;
        public PropertiedObject.Property<FontAttributes> COLUMN_FONT;
        public PropertiedObject.Property<CustomReport> PARENT;
        public PropertiedObject.Property<CustomReportColumn> COLUMNS;
        public PropertiedObject.Property<CustomReportSeries> SERIES;
        public PropertiedObject.Property<CustomReport> SUB_REPORTS;
        public PropertiedObject.Property<CustomReportFilter> FILTERS;
        public PropertiedObject.Property<CustomReportQueryPart> QUERY_PARTS;
    }
}

