/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import ordermate.OrderMate;
import ordermate.database.reports.config.custom.CustomReportHelper;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.JasperBorder;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;
import ordermate.reports.dynamicjasper.ArbitraryPeriodReportAdapter;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;

public class CustomReportBuilder
extends ReportBuilder {
    private final int GLOBAL_FOOTER_VAR_HEIGHT = 30;
    private final CustomReportCompiler rootCompiler;

    public CustomReportBuilder(CustomReportCompiler compiler) {
        ReportBuilder.TemplateFormat format = compiler.getReport().isLandscape() ? (compiler.getReport().isShowBanner() ? ReportBuilder.TemplateFormat.A4Landscape : ReportBuilder.TemplateFormat.A4LandscapeNoHeader) : (compiler.getReport().isShowBanner() ? ReportBuilder.TemplateFormat.A4Portrait : ReportBuilder.TemplateFormat.A4PortraitNoHeader);
        this.setReportFormat(format);
        this.rootCompiler = compiler;
    }

    public void initReport() throws DJBuilderException {
        this.addReport(this.rootCompiler);
    }

    private void addReport(CustomReportCompiler theCompiler) throws DJBuilderException {
        boolean newPage = false;
        if (theCompiler == this.rootCompiler) {
            if (theCompiler.getReport().isLandscape()) {
                this.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
            }
            if (theCompiler.getReport().isShowTitle()) {
                this.setTitle(this.makeTitle());
                this.setSubtitle(theCompiler.getReport().getSubTitle());
                this.getReportBuilder().setTitleHeight(theCompiler.getReport().getTitleHeight());
                CustomReportHelper.adjustFont(this.getStyles().getTitleStyle(), theCompiler.getReport().getTitleFont());
                CustomReportHelper.adjustFont(this.getStyles().getSubtitleStyle(), theCompiler.getReport().getSubtitleFont());
            } else {
                this.getReportBuilder().setTitleHeight(1);
                this.getReportBuilder().setSubtitleHeight(1);
            }
        } else {
            newPage = theCompiler.getReport().isPageBreak();
        }
        ArrayList<CustomReportSeries> series = new ArrayList<CustomReportSeries>(theCompiler.getReport().getSeries());
        PropertyComparator comparator = new PropertyComparator((PropertiedObject.Property<? extends Comparable>)CustomReportSeries.Properties.SEQUENCE);
        Collections.sort(series, comparator);
        for (CustomReportSeries nextSeries : series) {
            this.addSeriesSubReport(nextSeries, this.createSeriesReport(theCompiler, nextSeries), newPage);
            newPage = false;
        }
        for (CustomReportCompiler nextSubReportCompiler : theCompiler.getSubReportCompilers()) {
            this.addReport(nextSubReportCompiler);
        }
    }

    private String makeTitle() {
        PeriodReportAdapter adapter = this.rootCompiler.getPeriodAdapter();
        StringBuilder SB = new StringBuilder(this.rootCompiler.getReport().getTitle()).append(" ");
        if (adapter instanceof ArbitraryPeriodReportAdapter) {
            ArbitraryPeriodReportAdapter arbAdapter = (ArbitraryPeriodReportAdapter)adapter;
            SB.append(DateTimeUtils.getMediumDateFormat().format(arbAdapter.getStart()));
            SB.append(" to ");
            SB.append(DateTimeUtils.getMediumDateFormat().format(arbAdapter.getEnd()));
        } else if (PeriodReportAdapter.DAILY.equals(adapter)) {
            SB.append(DateTimeUtils.getMediumDateFormat().format(this.rootCompiler.getReportDate()));
        } else if (PeriodReportAdapter.WEEK_ENDING.equals(adapter)) {
            SB.append("for week ending ").append(DateTimeUtils.getMediumDateFormat().format(this.rootCompiler.getReportDate()));
        } else if ("Custom".equals(adapter.getLabel())) {
            SB.append(adapter.getFormatter().format(adapter.getDateOffset().calcStart(this.rootCompiler.getReportDate())));
            SB.append(" to ");
            SB.append(adapter.getFormatter().format(adapter.getDateOffset().calcEnd(this.rootCompiler.getReportDate())));
        } else {
            SB.append(this.rootCompiler.getPeriodAdapter().formatDateForDisplay(this.rootCompiler.getReportDate()));
        }
        return SB.toString();
    }

    private DynamicReport createSeriesReport(CustomReportCompiler theCompiler, CustomReportSeries series) {
        Page page;
        ReportBuilder subBuilder;
        if (this.rootCompiler.getReport().isLandscape()) {
            subBuilder = new ReportBuilder(new OrderMateMinimalistStyle(), ReportBuilder.TemplateFormat.A4Landscape);
            page = Page.Page_A4_Landscape();
            page.setOrientationPortrait(false);
            subBuilder.getReportBuilder().setPageSizeAndOrientation(page);
        } else {
            subBuilder = new ReportBuilder(new OrderMateMinimalistStyle(), ReportBuilder.TemplateFormat.A4Portrait);
            page = Page.Page_A4_Portrait();
            subBuilder.getReportBuilder().setPageSizeAndOrientation(page);
        }
        ReportMeta meta = new ReportMeta(subBuilder, series, theCompiler);
        this.adjustFontsAndSizes(meta);
        this.doTitle(meta);
        if (series.isInvertedTable()) {
            this.doInvertedTable(meta);
        } else {
            this.doColumns(meta);
        }
        this.doMargins(meta);
        return subBuilder.buildJasperReport();
    }

    private void adjustFontsAndSizes(ReportMeta meta) {
        Style totalStyle;
        CustomReportSeries series = meta.series;
        ReportBuilder subBuilder = meta.subBuilder;
        String rotation = series.getReport().getHeaderRotation();
        if ("Left".equals(rotation)) {
            subBuilder.getStyles().getColumnHeaderStyle().setRotation(Rotation.LEFT);
        } else if ("Right".equals(rotation)) {
            subBuilder.getStyles().getColumnHeaderStyle().setRotation(Rotation.RIGHT);
        }
        CustomReportHelper.adjustFont(subBuilder.getStyles().getColumnHeaderStyle(), series.getReport().getColumnHeaderFont());
        CustomReportHelper.adjustFont(subBuilder.getStyles().getColumnDetailStyle(), series.getReport().getColumnFont());
        CustomReportHelper.adjustFont(subBuilder.getStyles().getGroupedDetailStyle(), series.getReport().getColumnFont());
        subBuilder.getReportBuilder().setHeaderHeight(series.getReport().getHeaderHeight());
        Style numberStyle = totalStyle = subBuilder.getStyles().getGroupedDetailStyle();
        if (series.isShowTotal()) {
            subBuilder.setUseGrandTotal(true);
            Font font = totalStyle.getFont();
            font.setBold(true);
            totalStyle.setFont(font);
            try {
                numberStyle = (Style)subBuilder.getStyles().getGroupedDetailStyle().clone();
                numberStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        Style titleStyle = subBuilder.getStyles().getTitleStyle();
        CustomReportHelper.adjustFont(titleStyle, series.getReport().getTitleFont());
        subBuilder.getReportBuilder().setTitleHeight(series.getReport().getTitleHeight());
        meta.numberStyle = numberStyle;
    }

    private void doTitle(ReportMeta meta) {
        if (meta.series.isShowTitle()) {
            meta.subBuilder.setTitle(meta.series.getLabel());
        } else {
            meta.subBuilder.getReportBuilder().setTitleHeight(1);
            meta.subBuilder.getReportBuilder().setSubtitleHeight(1);
        }
    }

    private SimpleColumn createColumn(ReportMeta meta, CustomReportColumn column) {
        Class<Object> dataType = meta.compiler.getMasterTableModel().getColumnClass(meta.compiler.getReport().getSequencedColumns().indexOf(column));
        if (dataType == null) {
            OrderMate.LOG.warn("Data type was null for column :" + column.getDataString());
            dataType = Double.class;
        }
        ColumnProperty prop = new ColumnProperty(column.getLabel(), dataType);
        SimpleColumn jasperCol = new SimpleColumn();
        jasperCol.setColumnProperty(prop);
        jasperCol.setName(column.getUniqueKey());
        jasperCol.setTitle(this.getColumnTitle(column.getLabel()));
        jasperCol.setPattern(column.getFormat());
        this.styleColumn(meta, column, jasperCol, dataType);
        return jasperCol;
    }

    private String getColumnTitle(String columnLabel) {
        return JasperReportHelper.runMaskedDBQuery(PersistenceManager.getPersistenceDelegate(), columnLabel);
    }

    private void doColumns(ReportMeta meta) {
        CustomReportSeries series = meta.series;
        ReportBuilder subBuilder = meta.subBuilder;
        HashMap<String, SimpleColumn> columnMap = null;
        if (!series.getGroupList().isEmpty()) {
            columnMap = new HashMap<String, SimpleColumn>();
        }
        List<CustomReportColumn> columns = meta.compiler.getReport().getSequencedColumns();
        Style colStyle = subBuilder.getStyles().getColumnDetailStyle();
        CustomReportHelper.adjustFont(colStyle, series.getReport().getColumnFont());
        List<String> groupList = series.getGroupList();
        ArrayList<SimpleColumn> columnsToSum = new ArrayList<SimpleColumn>();
        for (int x = 0; x < columns.size(); ++x) {
            CustomReportColumn column = columns.get(x);
            if (!column.isVisible()) continue;
            SimpleColumn jasperCol = this.createColumn(meta, column);
            subBuilder.getReportBuilder().addColumn((AbstractColumn)jasperCol);
            if (columnMap != null) {
                columnMap.put(column.getUniqueKey(), jasperCol);
            }
            if (series.isShowAverage() && column.isInAverage()) {
                if (column.isIgnoreZerosInAverage()) {
                    subBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)jasperCol, new AverageCustomCalculation(x, meta.compiler.getData(series)), meta.numberStyle);
                } else {
                    subBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)jasperCol, DJCalculation.AVERAGE, meta.numberStyle);
                }
            }
            if (!series.isShowTotal() || !column.isInTotal()) continue;
            if (groupList != null && !groupList.isEmpty()) {
                columnsToSum.add(jasperCol);
                continue;
            }
            subBuilder.getReportBuilder().setGlobalFooterVariableHeight(30);
            subBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)jasperCol, DJCalculation.SUM, meta.numberStyle);
        }
        if (groupList != null && !groupList.isEmpty() && !columnsToSum.isEmpty()) {
            SimpleColumn groupByColumn;
            SimpleColumn simpleColumn = groupByColumn = columnMap != null ? (SimpleColumn)columnMap.get(groupList.get(0)) : null;
            if (groupByColumn != null) {
                this.addGroups(subBuilder, groupByColumn, columnsToSum);
            }
        }
    }

    private void addGroups(ReportBuilder reportBuilder, SimpleColumn groupByColumn, List<SimpleColumn> columnsToSum) {
        ReportBuilder.GroupSpec groupSpec = new ReportBuilder.GroupSpec((PropertyColumn)groupByColumn);
        groupSpec.setLayout(GroupLayout.DEFAULT);
        GroupBuilder groupBuilder = new GroupBuilder();
        groupBuilder.setGroupLayout(groupSpec.getLayout());
        groupBuilder.setCriteriaColumn((PropertyColumn)groupByColumn);
        Style totalStyle = this.getStyles().getFooterVariableStyle();
        totalStyle.getFont().setBold(true);
        totalStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        for (SimpleColumn column : columnsToSum) {
            groupBuilder.addFooterVariable((AbstractColumn)column, DJCalculation.SUM, totalStyle);
            reportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)column, DJCalculation.SUM, totalStyle);
        }
        groupByColumn.setStyle(groupSpec.getGroupedColumnStyle());
        groupByColumn.setHeaderStyle(groupSpec.getGroupedColumnStyle());
        groupByColumn.setWidth(Integer.valueOf(125));
        reportBuilder.getReportBuilder().addGroup(groupBuilder.build());
    }

    private void doMargins(ReportMeta meta) {
        meta.subBuilder.getReportBuilder().setBottomMargin(meta.series.getBottomMargin());
        meta.subBuilder.getReportBuilder().setTopMargin(meta.series.getTopMargin());
    }

    private void addSeriesSubReport(CustomReportSeries series, DynamicReport report, boolean newPage) throws DJBuilderException {
        this.getReportBuilder().addConcatenatedReport(report, (LayoutManager)new ClassicLayoutManager(), series.getDataSource(), 0, 10, newPage);
    }

    private void doInvertedTable(ReportMeta meta) {
        TableModel model = meta.compiler.getData(meta.series);
        ReportBuilder subBuilder = meta.subBuilder;
        CustomReportColumn firstColumn = meta.series.getReport().getColumns().get(0);
        firstColumn.getBackground();
        for (int i = 0; i < model.getColumnCount(); ++i) {
            SimpleColumn column = new SimpleColumn();
            column.setTitle(model.getColumnName(i).isEmpty() ? "A" + i : model.getColumnName(i));
            column.setName("A" + i);
            String title = column.getTitle();
            ColumnProperty prop = new ColumnProperty(title, String.class);
            column.setColumnProperty(prop);
            subBuilder.getReportBuilder().addColumn((AbstractColumn)column);
            this.styleColumn(meta, firstColumn, column, i == 0 ? String.class : Double.class);
        }
    }

    private void styleColumn(ReportMeta meta, CustomReportColumn column, SimpleColumn jasperCol, Class dataType) {
        if (column.getHeaderBackground() != null) {
            if (jasperCol.getHeaderStyle() == null) {
                Style newStyle = CustomReportHelper.copyStyle(this.getStyles().getColumnHeaderStyle());
                jasperCol.setHeaderStyle(newStyle);
            }
            jasperCol.getHeaderStyle().setBackgroundColor(column.getHeaderBackground());
            CustomReportHelper.adjustFont(jasperCol.getHeaderStyle(), meta.series.getReport().getColumnHeaderFont());
        }
        Style colStyle = jasperCol.getStyle();
        String border = meta.series.getReport().getColumnBorder();
        JasperBorder jBorder = JasperBorder.Thin;
        if (border == null) {
            jBorder = JasperBorder.Thin;
        } else if (border.equals("Dotted")) {
            jBorder = JasperBorder.Dotted;
        } else if (border.equals("Pen1")) {
            jBorder = JasperBorder.Pen1;
        } else if (border.equals("Pen2")) {
            jBorder = JasperBorder.Pen2;
        } else if (border.equals("Pen4")) {
            jBorder = JasperBorder.Pen4;
        } else if (border.equals("None")) {
            jBorder = JasperBorder.None;
        }
        colStyle.setBorder(jBorder.getBorder());
        if (column.getBackground() != null) {
            colStyle.setBackgroundColor(column.getBackground());
            colStyle.setTransparent(false);
        }
        if (dataType != String.class) {
            colStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        }
        if (column.getWidth() != null) {
            jasperCol.setWidth(column.getWidth());
        }
        CustomReportHelper.adjustFont(colStyle, meta.series.getReport().getColumnFont());
    }

    class ReportMeta {
        final ReportBuilder subBuilder;
        final CustomReportSeries series;
        final CustomReportCompiler compiler;
        Style numberStyle;

        ReportMeta(ReportBuilder subBuilder, CustomReportSeries series, CustomReportCompiler theCompiler) {
            this.subBuilder = subBuilder;
            this.series = series;
            this.compiler = theCompiler;
        }
    }

    class AverageCustomCalculation
    implements CustomExpression {
        private final int columnIndex;
        private final TableModel model;

        public AverageCustomCalculation(int index, TableModel tableModel) {
            this.columnIndex = index;
            this.model = tableModel;
        }

        public Object evaluate(Map fields, Map variables, Map arg2) {
            double sumValues = 0.0;
            int countValues = 0;
            double currentValue = 0.0;
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                try {
                    currentValue = Double.parseDouble(this.model.getValueAt(i, this.columnIndex).toString());
                }
                catch (Exception ex) {
                    currentValue = 0.0;
                }
                sumValues += currentValue;
                if (currentValue == 0.0) continue;
                ++countValues;
            }
            if (countValues == 0) {
                return 0.0;
            }
            return sumValues / (double)countValues;
        }

        public String getClassName() {
            return Double.class.getName();
        }
    }
}

