/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import au.com.ordermate.oquery.search.QueryPart;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ordermate.database.gui.FontAttributes;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportQueryPart;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.derived.DerivedReportColumn;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;

public class CustomReportIO {
    private static final int ERROR_PREVENTION_THRESHOLD = 5000000;
    private DataOutputStream out;
    private DataInputStream in;

    public void writeCustomReport(CustomReport report, OutputStream output) throws IOException {
        this.out = new DataOutputStream(output);
        this.writeReport(report);
        this.out.flush();
        this.out.close();
    }

    public CustomReport readIn(InputStream input) throws IOException {
        this.in = new DataInputStream(input);
        CustomReport report = this.readReport(null);
        this.in.close();
        return report;
    }

    private void writeReport(CustomReport report) throws IOException {
        this.writeString(report.getTitle());
        this.writeString(report.getSubTitle());
        this.writeString(report.getDefaultPeriod());
        this.writeString(report.getHeaderRotation());
        this.writeString(report.getGrouping().name());
        this.writeString(report.getColumnBorder());
        this.writeInteger(report.getTitleHeight());
        this.writeInteger(report.getHeaderHeight());
        this.writeInteger(report.getSequence());
        this.writeBoolean(report.isLandscape());
        this.writeBoolean(report.isShowTitle());
        this.writeBoolean(report.isShowBanner());
        this.writeBoolean(report.isPageBreak());
        this.writeFontAttributes(report.getTitleFont());
        this.writeFontAttributes(report.getSubtitleFont());
        this.writeFontAttributes(report.getColumnHeaderFont());
        this.writeFontAttributes(report.getColumnFont());
        this.writeInteger(report.getSeries().size());
        for (CustomReportSeries series : report.getSeries()) {
            this.writeSeries(series);
        }
        this.writeInteger(report.getColumns().size());
        for (CustomReportColumn col : report.getColumns()) {
            this.writeColumn(col);
        }
        this.writeInteger(report.getQueryParts().size());
        for (CustomReportQueryPart part : report.getQueryParts()) {
            this.writeQueryPart(part);
        }
        this.writeInteger(report.getSubReports().size());
        for (CustomReport sub : report.getSubReports()) {
            this.writeReport(sub);
        }
    }

    private void writeSeries(CustomReportSeries series) throws IOException {
        this.writeString(series.getLabel());
        this.writeString(series.getOrdering());
        this.writeString(series.getGrouping());
        this.writeInteger(series.getLimit());
        this.writeInteger(series.getTopMargin());
        this.writeInteger(series.getBottomMargin());
        this.writeInteger(series.getSequence());
        this.writeBoolean(series.isShowAverage());
        this.writeBoolean(series.isShowTotal());
        this.writeBoolean(series.isShowTitle());
    }

    private void readSeries(CustomReport parent) throws IOException {
        CustomReportSeries series = new CustomReportSeries(parent);
        series.setLabel(this.readString());
        series.setOrdering(this.readString());
        series.setGrouping(this.readString());
        series.setLimit(this.readInteger());
        series.setTopMargin(this.readInteger());
        series.setBottomMargin(this.readInteger());
        series.setSequence(this.readInteger());
        series.setShowAverage(this.readBoolean());
        series.setShowTotal(this.readBoolean());
        series.setShowTitle(this.readBoolean());
        parent.addSeries(series);
    }

    private void writeColumn(CustomReportColumn col) throws IOException {
        this.writeBoolean(col instanceof DirectReportColumn);
        this.writeString(col.getLabel());
        this.writeString(col.getUniqueKey());
        this.writeString(col.getFormat());
        this.writeString(col.getDefaultValue());
        this.writeInteger(col.getSequence());
        this.writeInteger(col.getWidth());
        this.writeBoolean(col.isVisible());
        this.writeBoolean(col.isInAverage());
        this.writeBoolean(col.isInTotal());
        this.writeColour(col.getBackground());
        this.writeColour(col.getHeaderBackground());
        if (col instanceof DirectReportColumn) {
            this.writeString(((DirectReportColumn)col).getBaseReport().name());
            this.writeString(((DirectReportColumn)col).getSubType());
            this.writeString(((DirectReportColumn)col).getBaseReportProperty());
            this.writeBoolean(((DirectReportColumn)col).isRemoveIfNull());
            this.writeBoolean(((DirectReportColumn)col).isOmitGroup());
        } else {
            this.writeString(((DerivedReportColumn)col).getOperation());
        }
    }

    private void readColumn(CustomReport parent) throws IOException {
        CustomReportColumn col = this.readBoolean() ? new DirectReportColumn(parent, "") : new DerivedReportColumn(parent, "");
        col.setLabel(this.readString());
        col.setUniqueKey(this.readString());
        col.setFormat(this.readString());
        col.setDefaultValue(this.readString());
        col.setSequence(this.readInteger());
        col.setWidth(this.readInteger());
        col.setVisible(this.readBoolean());
        col.setInAverage(this.readBoolean());
        col.setInTotal(this.readBoolean());
        col.setBackground(this.readColour());
        col.setHeaderBackground(this.readColour());
        if (col instanceof DirectReportColumn) {
            ((DirectReportColumn)col).setBaseReport(BaseReport.valueOf(this.readString()));
            ((DirectReportColumn)col).setSubType(this.readString());
            ((DirectReportColumn)col).setBaseReportProperty(this.readString());
            ((DirectReportColumn)col).setRemoveIfNull(this.readBoolean());
            ((DirectReportColumn)col).setOmitGroup(this.readBoolean());
        } else {
            ((DerivedReportColumn)col).setOperation(this.readString());
        }
        parent.addColumn(col);
    }

    private void writeQueryPart(CustomReportQueryPart part) throws IOException {
        this.writeString(part.getBaseReport() == null ? null : part.getBaseReport().name());
        this.writeString(part.getSubType());
        this.writeString(part.getPartType().name());
        this.writeString(part.getColName());
        this.writeString(part.getPartText());
        this.writeString(part.getExtra());
        this.writeInteger(part.getSequence());
    }

    private void readQueryPart(CustomReport report) throws IOException {
        String base = this.readString();
        String subType = this.readString();
        String partType = this.readString();
        CustomReportQueryPart part = new CustomReportQueryPart(report, QueryPart.valueOf(partType));
        part.setBaseReport(base == null ? null : BaseReport.valueOf(base));
        part.setSubType(subType);
        part.setColName(this.readString());
        part.setPartText(this.readString());
        part.setExtra(this.readString());
        part.setSequence(this.readInteger());
        report.addQueryPart(part);
    }

    private CustomReport readReport(CustomReport parent) throws IOException {
        CustomReport report = new CustomReport(parent);
        if (parent != null) {
            parent.addSubReport(report);
        }
        report.setTitle(this.readString());
        report.setSubTitle(this.readString());
        report.setDefaultPeriod(this.readString());
        report.setHeaderRotation(this.readString());
        report.setGrouping(BaseReportGrouping.valueOf(this.readString()));
        report.setColumnBorder(this.readString());
        report.setTitleHeight(this.readInteger());
        report.setHeaderHeight(this.readInteger());
        report.setSequence(this.readInteger());
        report.setLandscape(this.readBoolean());
        report.setShowTitle(this.readBoolean());
        report.setShowBanner(this.readBoolean());
        report.setPageBreak(this.readBoolean());
        this.readFontAttributes(report.getTitleFont());
        this.readFontAttributes(report.getSubtitleFont());
        this.readFontAttributes(report.getColumnHeaderFont());
        this.readFontAttributes(report.getColumnFont());
        int numSeries = this.readInteger();
        for (int i = 0; i < numSeries; ++i) {
            this.readSeries(report);
        }
        int numCols = this.readInteger();
        for (int i = 0; i < numCols; ++i) {
            this.readColumn(report);
        }
        int parts = this.readInteger();
        for (int i = 0; i < parts; ++i) {
            this.readQueryPart(report);
        }
        int numSubs = this.readInteger();
        for (int i = 0; i < numSubs; ++i) {
            this.readReport(report);
        }
        return report;
    }

    private void writeInteger(Integer value) throws IOException {
        if (value != null) {
            this.out.writeInt(value);
        } else {
            this.out.writeInt(Integer.MIN_VALUE);
        }
    }

    private Integer readInteger() throws IOException {
        int value = this.in.readInt();
        if (value == Integer.MIN_VALUE) {
            return null;
        }
        return value;
    }

    private void writeBoolean(boolean value) throws IOException {
        this.out.writeBoolean(value);
    }

    private boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    private void writeString(String toWrite) throws IOException {
        if (toWrite == null) {
            this.out.writeInt(Integer.MIN_VALUE);
        } else {
            this.out.writeInt(toWrite.length());
            this.out.write(toWrite.getBytes());
        }
    }

    private String readString() throws IOException {
        int length = this.in.readInt();
        if (length < 0) {
            return null;
        }
        if (length >= 5000000) {
            throw new IOException("Invalid input file, error prevention threshold reached! Count your lucky stars you didn't get a heap space error.");
        }
        byte[] bytes = new byte[length];
        this.in.read(bytes);
        return new String(bytes);
    }

    private void writeColour(Color value) throws IOException {
        if (value != null) {
            this.writeInteger(value.getRGB());
        } else {
            this.writeInteger(null);
        }
    }

    private Color readColour() throws IOException {
        Integer value = this.readInteger();
        if (value == null) {
            return null;
        }
        return new Color(value);
    }

    private void writeFontAttributes(FontAttributes att) throws IOException {
        this.writeColour(att.getColour());
        this.writeString(att.getFontFamily());
        this.writeInteger(att.getPointSize());
        this.writeBoolean(att.isBold());
        this.writeBoolean(att.isItalic());
    }

    private void readFontAttributes(FontAttributes att) throws IOException {
        att.setColour(this.readColour());
        att.setFontFamily(this.readString());
        att.setPointSize(this.readInteger());
        att.setBold(this.readBoolean());
        att.setItalic(this.readBoolean());
    }
}

