/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.reports.MakesReport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportProvider;
import ordermate.database.reports.config.custom.CustomReportSearchParams;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

@MakesReport(value="Custom", description="Your custom built report", category="Custom")
public class CustomReportMaker
extends ConfigurableReportMaker<CustomReportSearchParams, CustomReportProvider> {
    private static final String REPORT = "Custom Report";
    private static final String PERIOD = "Period";

    @Override
    protected CustomReportSearchParams createSearchFilter() {
        CustomReport report = this.resolveCustomReport();
        if (report == null) {
            report = new CustomReport("No Report", null);
        }
        return new CustomReportSearchParams(report);
    }

    private CustomReport resolveCustomReport() {
        if (this.getReportConfig() == null) {
            return null;
        }
        ReportProperty prop = this.getReportConfig().getReportProperty(REPORT);
        CustomReport report = prop.getAsObject(CustomReport.class, null);
        if (report == null && (report = PersistenceManager.getObject(CustomReport.class, Query.select(CustomReport.class).equals(CustomReport.Properties.TITLE, prop.getValue()).isNull(CustomReport.Properties.PARENT).toString())) == null) {
            OrderMate.LOG.warn("Cannot find CustomReport for " + prop.getValue());
        }
        if (report == null && (report = PersistenceManager.getObject(CustomReport.class, Query.select(CustomReport.class).equals(CustomReport.Properties.TITLE, this.getReportConfig().getLabel()).isNull(CustomReport.Properties.PARENT).toString())) == null) {
            OrderMate.LOG.warn("Cannot find CustomReport for " + prop.getValue());
        }
        return report;
    }

    @Override
    protected CustomReportProvider createReportProvider(CustomReportSearchParams yourSearcher) {
        if (yourSearcher == null) {
            return null;
        }
        CustomReportCompiler compiler = new CustomReportCompiler(yourSearcher);
        ReportProperty property = this.getReportConfig().getReportProperty(PERIOD);
        String period = property.getStringValue("WEEK_ENDING");
        PeriodReportAdapter thePeriod = PeriodReportAdapter.WEEK_ENDING;
        for (PeriodReportAdapter nextPeriod : PeriodReportAdapter.getStandardPeriods()) {
            if (!nextPeriod.getLabel().equals(period)) continue;
            thePeriod = nextPeriod;
        }
        compiler.setPeriodReportAdapter(thePeriod);
        compiler.setReportDate((Date)yourSearcher.getDateFilter().getSearchValue());
        CustomReportProvider provider = new CustomReportProvider(compiler);
        try {
            compiler.compileReport();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create report from custom compiler", (Throwable)ex);
        }
        return provider;
    }

    @Override
    public List<ReportProperty> getReportProperties() {
        ArrayList<ReportProperty> props = new ArrayList<ReportProperty>();
        props.add(ReportProperty.makeConfigReportProperty(REPORT, this.getReportConfig()));
        props.add(ReportProperty.makeConfigReportProperty(PERIOD, this.getReportConfig()));
        return props;
    }
}

