/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.config.custom.CustomReportBuilder;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class CustomReportProvider
extends AbstractReportProvider {
    private final CustomReportCompiler compiler;

    public CustomReportProvider(CustomReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRTableModelDataSource(this.compiler.getMasterTableModel());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.addReportData(this.compiler);
        CustomReportBuilder builder = new CustomReportBuilder(this.compiler);
        try {
            builder.initReport();
            this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("cannot compile custom report", (Throwable)ex);
        }
        return builder.buildJasperReport();
    }

    private void addReportData(CustomReportCompiler theCompiler) {
        for (CustomReportSeries series : theCompiler.getReport().getSeries()) {
            this.addParam(series.getDataSource(), new JRTableModelDataSource(theCompiler.getData(series)));
        }
        for (CustomReportCompiler subReportCompiler : theCompiler.getSubReportCompilers()) {
            this.addReportData(subReportCompiler);
        }
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        return new CustomReportBuilder(this.compiler);
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    public CustomReportCompiler getCompiler() {
        return this.compiler;
    }
}

