/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.QueryModifier;
import au.com.ordermate.oquery.search.QueryPart;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.Sequenced;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.direct.BaseReport;

@Entity
@Table(name="report_custom_query_part")
public class CustomReportQueryPart
extends PersistentObject
implements Sequenced,
SaveableChild {
    public static final Props Properties = new Props();
    private BaseReport baseReport;
    private String subType;
    private Reference<CustomReport> parent;
    private QueryPart partType;
    private String colName;
    private String partText;
    private String extra;
    private int sequence;

    @Deprecated
    public CustomReportQueryPart() {
        this.parent = this.createReference(CustomReportQueryPart.Properties.PARENT);
    }

    public CustomReportQueryPart(CustomReport parent, QueryPart yourType) {
        this(parent, yourType, null, null, null);
    }

    public CustomReportQueryPart(CustomReport report, QueryPart part, BaseReport base, String colName, String partText) {
        this.parent = this.createReference(CustomReportQueryPart.Properties.PARENT);
        this.partType = part;
        this.setParent(report);
        this.baseReport = base;
        this.colName = colName;
        this.partText = partText;
    }

    @Column(name="base_report")
    @Enumerated(value=EnumType.STRING)
    public BaseReport getBaseReport() {
        return this.baseReport;
    }

    public void setBaseReport(BaseReport value) {
        this.baseReport = value;
    }

    @Column(name="sub_type")
    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String value) {
        this.subType = value;
    }

    @Column(name="part_type")
    @Enumerated(value=EnumType.STRING)
    public QueryPart getPartType() {
        return this.partType;
    }

    public void setPartType(QueryPart yourType) {
        this.partType = yourType;
    }

    @Column(name="col_name")
    public String getColName() {
        return this.colName;
    }

    public void setColName(String value) {
        this.colName = value;
    }

    @Column(name="part_text")
    public String getPartText() {
        return this.partText;
    }

    public void setPartText(String value) {
        this.partText = value;
    }

    @Column(name="extra")
    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String value) {
        this.extra = value;
    }

    @ManyToOne
    @JoinColumn(name="fk_report_custom")
    public CustomReport getParent() {
        return this.parent.get();
    }

    protected void setParent(CustomReport yourParent) {
        this.parent.set(yourParent);
    }

    public int compareTo(Object o) {
        return Sequenced.SequenceComparator.getInst().compare(this, o);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public static List<QueryModifier> createModifiers(List<CustomReportQueryPart> parts, BaseReport report, String subType) {
        ArrayList<QueryModifier> mods = new ArrayList<QueryModifier>();
        for (CustomReportQueryPart part : parts) {
            if (part.getBaseReport() != null && report != null && !report.equals((Object)part.getBaseReport()) || !CustomReportQueryPart.matchesType(subType, part.getSubType())) continue;
            mods.add(new CustomReportModifier(part));
        }
        return mods;
    }

    private static boolean matchesType(String subType, String toMatch) {
        if (subType == null && (toMatch == null || toMatch.isEmpty() || "ALL".equals(toMatch))) {
            return true;
        }
        return subType != null && ("ALL".equals(toMatch) || subType.equals(toMatch));
    }

    static class CustomReportModifier
    implements QueryModifier {
        private final CustomReportQueryPart part;

        CustomReportModifier(CustomReportQueryPart yourPart) {
            this.part = yourPart;
        }

        @Override
        public ObjectQuery modifyQuery(ObjectQuery query) {
            switch (this.part.getPartType()) {
                case SELECT: {
                    query.selectFunc(this.part.getPartText() + " as " + this.part.getColName());
                    break;
                }
                case GROUP: {
                    if ("Alias".equalsIgnoreCase(this.part.getExtra())) {
                        String group = this.part.getPartText();
                        query.selectFunc(group + " as " + this.part.getColName()).groupBy(group);
                        break;
                    }
                    if ("Separate".equalsIgnoreCase(this.part.getExtra())) {
                        query.selectFunc(this.part.getPartText()).groupBy(this.part.getColName());
                        break;
                    }
                    if (!StringUtils.isEmpty(this.part.getPartText())) {
                        String group = this.part.getPartText() + "." + this.part.getColName();
                        query.selectFunc(group).groupBy(group);
                        break;
                    }
                    String group = this.part.getColName();
                    query.groupBy(group);
                    break;
                }
                case ORDER: {
                    query.orderBy(this.part.getColName(), Boolean.TRUE.toString().equals(this.part.getPartText()));
                    break;
                }
                case HAVING: {
                    query.havingFunction(this.part.getPartText());
                    break;
                }
                case WHERE: {
                    query.whereFunction(this.part.getPartText());
                    break;
                }
                case JOIN: {
                    query.joinFunction(this.part.getPartText());
                    break;
                }
                case LIMIT: {
                    query.limit(Integer.parseInt(this.part.getPartText()));
                    break;
                }
                case FROM: {
                    if (!StringUtils.isEmpty(this.part.getColName())) {
                        query.from(this.part.getPartText(), this.part.getPartText());
                        break;
                    }
                    query.lastFrom(this.part.getPartText());
                    break;
                }
            }
            return query;
        }

        @Override
        public QueryPart getQueryPart() {
            return this.part.getPartType();
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<CustomReport> PARENT;
        public PropertiedObject.Property<BaseReport> BASE_REPORT;
        public PropertiedObject.Property<String> SUB_TYPE;
        public PropertiedObject.Property<QueryPart> PART_TYPE;
        public PropertiedObject.Property<String> COL_NAME;
        public PropertiedObject.Property<String> PART_TEXT;
        public PropertiedObject.Property<String> EXTRA;
        public PropertiedObject.Property SEQUENCE;
    }
}

