/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.reports.config.custom.CustomReport;

@Entity
@Table(name="report_custom_series")
public class CustomReportSeries
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<CustomReport> report;
    private String label;
    private String ordering;
    private String grouping;
    private Integer limit;
    private boolean showTotal;
    private boolean showAverage;
    private boolean showTitle;
    private boolean invertedTable;
    private int sequence;
    private int topMargin;
    private int bottomMargin;
    private transient List<String> orderList;
    private transient List<String> groupList;

    public CustomReportSeries() {
        this.report = this.createReference(CustomReportSeries.Properties.REPORT);
    }

    public CustomReportSeries(CustomReport parentReport) {
        this.report = this.createReference(CustomReportSeries.Properties.REPORT);
        this.report.set(parentReport);
        this.label = "New Series";
        this.ordering = "";
        this.limit = null;
        this.topMargin = 5;
        this.bottomMargin = 5;
    }

    public CustomReportSeries(CustomReportSeries toCopy) {
        this.report = this.createReference(CustomReportSeries.Properties.REPORT);
        this.label = "Copy of " + toCopy.label;
        this.ordering = toCopy.ordering;
        this.report.set(toCopy.getReport());
    }

    @ManyToOne
    @JoinColumn(name="fk_report_custom")
    public CustomReport getReport() {
        return this.report.get();
    }

    protected void setReport(CustomReport value) {
        this.report.set(value);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="ordering")
    public String getOrdering() {
        return this.ordering;
    }

    public void setOrdering(String value) {
        if (value != null) {
            this.ordering = value;
            this.orderList = null;
        }
    }

    @Transient
    public List<String> getOrderList() {
        if (this.orderList == null) {
            this.orderList = StringUtils.splitToList(this.ordering, ",");
            if (this.orderList.get(0).isEmpty()) {
                this.orderList = Collections.emptyList();
            }
        }
        return this.orderList;
    }

    @Column(name="grouping")
    public String getGrouping() {
        return this.grouping;
    }

    public void setGrouping(String value) {
        if (value != null) {
            this.grouping = value;
            this.groupList = null;
        }
    }

    @Transient
    public List<String> getGroupList() {
        if (this.groupList == null) {
            this.groupList = StringUtils.splitToList(this.grouping, ",");
        }
        return this.groupList;
    }

    @Column(name="limiting")
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer value) {
        this.limit = value != null ? (value <= 0 ? null : value) : value;
    }

    @Column(name="show_total")
    public boolean isShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean value) {
        this.showTotal = value;
    }

    @Column(name="show_average")
    public boolean isShowAverage() {
        return this.showAverage;
    }

    public void setShowAverage(boolean value) {
        this.showAverage = value;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="show_title")
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean value) {
        this.showTitle = value;
    }

    @Column(name="invert_table")
    public boolean isInvertedTable() {
        return this.invertedTable;
    }

    public void setInvertedTable(boolean value) {
        this.invertedTable = value;
    }

    @Column(name="top_margin")
    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int value) {
        if (value >= 0) {
            this.topMargin = value;
        }
    }

    @Column(name="bottom_margin")
    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(int value) {
        if (value >= 0) {
            this.bottomMargin = value;
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Transient
    public String getDataSource() {
        StringBuilder SB = new StringBuilder();
        for (CustomReport theReport = this.getReport(); theReport != null; theReport = theReport.getParent()) {
            SB.append(theReport.getTitle()).append("_");
            SB.append(theReport.getSequence()).append("_");
        }
        SB.append(this.sequence);
        return SB.toString();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<CustomReport> REPORT;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> ORDERING;
        public PropertiedObject.Property<String> GROUPING;
        public PropertiedObject.Property<Integer> LIMIT;
        public PropertiedObject.Property<Integer> TOP_MARGIN;
        public PropertiedObject.Property<Integer> BOTTOM_MARGIN;
        public PropertiedObject.Property SHOW_TOTAL;
        public PropertiedObject.Property SHOW_AVERAGE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property SHOW_TITLE;
        public PropertiedObject.Property INVERTED_TABLE;
        public PersistentObject.DerivedProperty<String> ORDER_LIST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CustomReportSeries.class), "orderList");
        public PersistentObject.DerivedProperty<String> GROUP_LIST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CustomReportSeries.class), "groupList");
    }
}

