/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.PersistenceDelegate;
import ordermate.OrderMate;

public class JasperReportHelper {
    public static final String QUERY_MARKER = "~~";

    public static SimpleColumn makeColumn(String name, Class clazz) {
        ColumnProperty prop = new ColumnProperty(name, clazz);
        SimpleColumn column = new SimpleColumn();
        column.setColumnProperty(prop);
        column.setName(name);
        column.setTitle(name);
        return column;
    }

    public static Style centerAlignStyle(Style style) {
        Style centerAlign = style;
        centerAlign = JasperReportHelper.cloneStyle(centerAlign);
        centerAlign.setHorizontalAlign(HorizontalAlign.CENTER);
        return centerAlign;
    }

    public static Style rightAlignStyle(Style style) {
        Style rightAlign = style;
        rightAlign = JasperReportHelper.cloneStyle(rightAlign);
        rightAlign.setHorizontalAlign(HorizontalAlign.RIGHT);
        return rightAlign;
    }

    public static Style leftAlignStyle(Style style) {
        Style leftAlign = style;
        leftAlign = JasperReportHelper.cloneStyle(leftAlign);
        leftAlign.setHorizontalAlign(HorizontalAlign.LEFT);
        return leftAlign;
    }

    public static Style enableBoldFont(Style style, boolean enable) {
        Style currentFontStyle = style;
        currentFontStyle = JasperReportHelper.cloneStyle(currentFontStyle);
        currentFontStyle.getFont().setBold(enable);
        return currentFontStyle;
    }

    public static Style cloneStyle(Style style) {
        Style clonedStyle = style;
        try {
            clonedStyle = (Style)style.clone();
        }
        catch (CloneNotSupportedException e) {
            OrderMate.LOG.error("Unable to clone Style", (Throwable)e);
        }
        return clonedStyle;
    }

    public static String runMaskedDBQuery(PersistenceDelegate delegate, String text) {
        if (text != null && text.startsWith(QUERY_MARKER)) {
            Object[][] results = delegate.executeQuery(text.substring(QUERY_MARKER.length()), null);
            if (results != null && results.length > 0) {
                return (String)results[0][0];
            }
            return "";
        }
        return text;
    }

    public static SimpleColumn createSimpleColumn(String name, Class clazzType) {
        ColumnProperty prop = new ColumnProperty(name, clazzType);
        SimpleColumn column = new SimpleColumn();
        column.setColumnProperty(prop);
        column.setName(name);
        column.setTitle(name);
        return column;
    }
}

