/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.column;

import au.com.ordermate.util.id.SimpleIdGenerator;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.database.reports.config.custom.column.derived.DerivedReportColumn;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;

public class CustomColumnFactory {
    private SimpleIdGenerator gen = new SimpleIdGenerator(3, "");

    public CustomReportColumn makeColumn(CustomReportColumnType type, CustomReport report) {
        CustomReportColumn column = null;
        if (CustomReportColumnType.Derived.equals((Object)type)) {
            column = new DerivedReportColumn(report, this.nextKey(report));
        } else if (CustomReportColumnType.Direct.equals((Object)type)) {
            column = new DirectReportColumn(report, this.nextKey(report));
        } else {
            throw new IllegalArgumentException("Unknown column type " + (Object)((Object)type));
        }
        return column;
    }

    private String nextKey(CustomReport report) {
        String nextId = this.gen.nextSeed(null);
        boolean found = report.getColumn(nextId) != null;
        String lastId = "zz";
        while (found) {
            boolean bl = found = report.getColumn(nextId = this.gen.nextSeed(nextId)) != null;
            if (!lastId.equals(nextId)) continue;
            throw new IllegalArgumentException("Cannot make more than #zz columns!");
        }
        return nextId;
    }
}

