/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.column;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="report_custom_column")
@DiscriminatorColumn(name="column_type")
public abstract class CustomReportColumn
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<CustomReport> report;
    private String label;
    private String uniqueKey;
    private int sequence;
    private boolean visible;
    private String format;
    private String defaultValue;
    private Integer width;
    private boolean inTotal;
    private boolean inAverage;
    private boolean ignoreZerosInAverage;
    private Color background;
    private Color headerBackground;

    public CustomReportColumn() {
        this.report = this.createReference(CustomReportColumn.Properties.REPORT);
    }

    public CustomReportColumn(CustomReport parent, String yourKey) {
        this.report = this.createReference(CustomReportColumn.Properties.REPORT);
        this.report.set(parent);
        this.label = "New Column";
        this.uniqueKey = yourKey.toLowerCase();
        this.sequence = 1;
        this.visible = true;
        this.defaultValue = "0.0";
    }

    @ManyToOne
    @JoinColumn(name="fk_report_custom")
    public CustomReport getReport() {
        return this.report.get();
    }

    protected void setReport(CustomReport parent) {
        this.report.set(parent);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        if (value != null) {
            this.label = value;
        }
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    @Column(name="visible")
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    @Column(name="unique_key")
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String value) {
        if (value != null) {
            this.uniqueKey = value.toLowerCase();
        }
    }

    @Column(name="format")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    @Column(name="width")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer value) {
        this.width = value;
    }

    @Column(name="in_average")
    public boolean isInAverage() {
        return this.inAverage;
    }

    public void setInAverage(boolean value) {
        this.inAverage = value;
    }

    @Column(name="ignore_zeros_in_average")
    public boolean isIgnoreZerosInAverage() {
        return this.ignoreZerosInAverage;
    }

    public void setIgnoreZerosInAverage(boolean value) {
        this.ignoreZerosInAverage = value;
    }

    @Column(name="in_total")
    public boolean isInTotal() {
        return this.inTotal;
    }

    public void setInTotal(boolean value) {
        this.inTotal = value;
    }

    @Column(name="background")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color value) {
        this.background = value;
    }

    @Column(name="header_background")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getHeaderBackground() {
        return this.headerBackground;
    }

    public void setHeaderBackground(Color value) {
        this.headerBackground = value;
    }

    @Column(name="default_value")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Transient
    public abstract CustomReportColumnType getColumnType();

    @Transient
    public abstract String getDataString();

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public String toString() {
        return this.getDataString();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<CustomReport> REPORT;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<String> UNIQUE_KEY;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property VISIBLE;
        public PropertiedObject.Property<String> FORMAT;
        public PropertiedObject.Property<Boolean> IN_AVERAGE;
        public PropertiedObject.Property<Boolean> IGNORE_ZEROS_IN_AVERAGE;
        public PropertiedObject.Property<Boolean> IN_TOTAL;
        public PropertiedObject.Property<Integer> WIDTH;
        public PropertiedObject.Property<Color> BACKGROUND;
        public PropertiedObject.Property<Color> HEADER_BACKGROUND;
        public PropertiedObject.Property<String> DEFAULT_VALUE;
        public PersistentObject.DerivedProperty<CustomReportColumnType> COLUMN_TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CustomReportColumn.class), "columnType");
        public PersistentObject.DerivedProperty<String> DATA_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CustomReportColumn.class), "dataString");
    }
}

