/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.column;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperatorFactory;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportData;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.derived.NumericColumnValueOperator;
import ordermate.database.utils.LiteralOperator;

public class CustomReportOperatorFactory
extends NumericOperatorFactory {
    public static final char KEY_MARKER = '#';
    private CustomReport report;
    private CustomReportData rowCounter;

    public CustomReportOperatorFactory(CustomReport report) {
        this.report = report;
    }

    public CustomReportData getRowCounter() {
        if (this.rowCounter == null) {
            this.rowCounter = new CustomReportData(this.report);
        }
        return this.rowCounter;
    }

    @Override
    protected Operator makeOperatorFor(String label) {
        if (label.length() > 0 && label.charAt(0) == '#') {
            String key = label.substring(1);
            CustomReportColumn column = this.report.getColumn(key);
            if (column != null) {
                NumericColumnValueOperator op = new NumericColumnValueOperator(column, this.getRowCounter());
                return op;
            }
            throw new IllegalArgumentException("The column with key " + key + " is not present.");
        }
        Operator op = super.makeOperatorFor(label);
        return op != null ? op : new LiteralOperator(label);
    }
}

