/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.column.derived;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperator;
import java.util.List;
import ordermate.database.reports.config.custom.CustomReportData;
import ordermate.database.reports.config.custom.column.CustomReportColumn;

public class NumericColumnValueOperator
extends NumericOperator {
    private CustomReportColumn column;
    private static final String LABEL = "Col";
    private CustomReportData data;
    private int columnIndex;

    public NumericColumnValueOperator(CustomReportColumn yourColumn, CustomReportData counter) {
        this.column = yourColumn;
        this.data = counter;
        this.columnIndex = this.column.getReport().getSequencedColumns().indexOf(this.column);
    }

    public CustomReportColumn getColumn() {
        return this.column;
    }

    @Override
    public boolean isValid() {
        return this.column != null;
    }

    @Override
    public String getLabel() {
        return LABEL;
    }

    @Override
    public int getMaxOperands() {
        return 1;
    }

    @Override
    public int getMinOperands() {
        return 1;
    }

    @Override
    protected Number performOperation(List<Operator<?>> operands) {
        Object dataValue = this.data.getTableModel().getValueAt(this.data.getRow(), this.columnIndex);
        if (dataValue == null || dataValue instanceof String && ((String)dataValue).isEmpty()) {
            return Double.NaN;
        }
        if (dataValue instanceof Number) {
            return (Number)dataValue;
        }
        return Double.valueOf((String)dataValue);
    }
}

