/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.column.direct;

import au.com.ordermate.persistence.PropertiedObject;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Transient;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.database.reports.config.custom.column.direct.BaseReport;

@Entity
@DiscriminatorValue(value="Direct")
public class DirectReportColumn
extends CustomReportColumn {
    public static final Props Properties = new Props();
    private BaseReport baseReport;
    private String subType;
    private String baseReportProperty;
    private boolean removeIfNull;
    private boolean omitGroup = false;
    private transient String reportKey;

    @Deprecated
    public DirectReportColumn() {
    }

    public DirectReportColumn(CustomReport parent, String key) {
        super(parent, key);
        this.baseReport = BaseReport.Sales;
        this.baseReportProperty = "Current-Total";
    }

    @Override
    @Transient
    public CustomReportColumnType getColumnType() {
        return CustomReportColumnType.Direct;
    }

    @Column(name="base_report")
    @Enumerated(value=EnumType.STRING)
    public BaseReport getBaseReport() {
        return this.baseReport;
    }

    public void setBaseReport(BaseReport baseReport) {
        this.baseReport = baseReport != null ? baseReport : BaseReport.Sales;
        this.reportKey = null;
    }

    @Column(name="sub_type")
    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String value) {
        this.subType = value;
        this.reportKey = null;
    }

    @Transient
    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String value) {
        this.reportKey = value;
    }

    @Column(name="base_report_property")
    public String getBaseReportProperty() {
        return this.baseReportProperty;
    }

    public void setBaseReportProperty(String value) {
        this.baseReportProperty = value != null ? value : "No-Property";
    }

    @Column(name="omit_group")
    public boolean isOmitGroup() {
        return this.omitGroup;
    }

    public void setOmitGroup(boolean value) {
        this.omitGroup = value;
    }

    @Column(name="remove_if_null")
    public boolean isRemoveIfNull() {
        return this.removeIfNull;
    }

    public void setRemoveIfNull(boolean value) {
        this.removeIfNull = value;
    }

    @Override
    @Transient
    public String getDataString() {
        if (this.baseReport == null) {
            return "baseReport is null";
        }
        StringBuilder SB = new StringBuilder();
        if (BaseReport.Flexi.equals((Object)this.baseReport)) {
            SB.append(this.subType);
        } else {
            SB.append(this.baseReport.name());
        }
        SB.append(".").append(this.baseReportProperty);
        return SB.toString();
    }

    public static class Props
    extends CustomReportColumn.Props {
        public PropertiedObject.Property<BaseReport> BASE_REPORT;
        public PropertiedObject.Property<String> SUB_TYPE;
        public PropertiedObject.Property<String> BASE_REPORT_PROPERTY;
        public PropertiedObject.Property REMOVE_IF_NULL;
        public PropertiedObject.Property<Boolean> OMIT_GROUP;
    }
}

