/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.compiler;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.TableModel;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.compiler.CustomReportCompiler;

public class CustomReportCSV {
    private static DecimalFormatSymbols decimalFormatSymbols = null;

    public String convertToCSV(CustomReportCompiler compiler) {
        List<ColumnCSVMap> columnsMaps = this.mapColumns(compiler.getReport().getSequencedColumns(), compiler.getMasterTableModel());
        StringWriter sWriter = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)sWriter);
        for (CustomReportSeries series : compiler.getReport().getSeries()) {
            TableModel model = compiler.getData(series);
            int actualCols = columnsMaps.size();
            String[] values = new String[actualCols];
            for (int i = 0; i < actualCols; ++i) {
                values[i] = model.getColumnName(columnsMaps.get((int)i).index);
            }
            writer.writeNext(values);
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < actualCols; ++col) {
                    Format format = columnsMaps.get((int)col).format;
                    values[col] = format != null ? format.format(model.getValueAt(row, columnsMaps.get((int)col).index)) : String.valueOf(model.getValueAt(row, columnsMaps.get((int)col).index));
                }
                writer.writeNext(values);
            }
        }
        sWriter.flush();
        return sWriter.getBuffer().toString();
    }

    private List<ColumnCSVMap> mapColumns(List<CustomReportColumn> sequencedColumns, TableModel model) {
        ArrayList<ColumnCSVMap> columnMaps = new ArrayList<ColumnCSVMap>();
        block0: for (CustomReportColumn col : sequencedColumns) {
            if (!col.isVisible()) continue;
            ColumnCSVMap map = new ColumnCSVMap();
            map.column = col;
            if (col.getFormat() != null && !col.getFormat().trim().isEmpty()) {
                map.format = new UniFormatter(col.getFormat());
            }
            for (int i = 0; i < model.getColumnCount(); ++i) {
                if (!col.getLabel().equals(model.getColumnName(i))) continue;
                map.index = i;
                columnMaps.add(map);
                continue block0;
            }
        }
        return columnMaps;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (decimalFormatSymbols == null) {
            decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setNaN("?");
        }
        return decimalFormatSymbols;
    }

    class UniFormatter
    extends Format {
        private String baseString;
        private Format format;

        UniFormatter(String value) {
            this.baseString = value;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            if (this.format == null && obj != null) {
                if (obj instanceof Number) {
                    DecimalFormat decimalFormat = new DecimalFormat(this.baseString, CustomReportCSV.getDecimalFormatSymbols());
                    this.format = decimalFormat;
                } else if (obj instanceof Date) {
                    this.format = new SimpleDateFormat(this.baseString);
                }
            }
            if (this.format != null && obj != null) {
                return this.format.format(obj, toAppendTo, pos);
            }
            toAppendTo.append(String.valueOf(obj));
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            if (this.format != null) {
                return this.format.parseObject(source, pos);
            }
            return null;
        }
    }

    class ColumnCSVMap {
        CustomReportColumn column;
        Format format;
        int index;

        ColumnCSVMap() {
        }
    }
}

