/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.compiler;

import au.com.ordermate.util.StringUtils;
import java.util.Map;
import java.util.Set;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.compiler.CustomReportTableModel;

public abstract class CustomReportColumnStuffer {
    public abstract void stuffColumn(CustomReportColumn var1, Map<String, BaseReportCompiler> var2, Set<Object> var3, CustomReportTableModel var4);

    protected void checkColumnsForDefaultValue(CustomReportColumn column, CustomReportTableModel model, Class columnClazz) {
        int columnIndex = column.getReport().getSequencedColumns().indexOf(column);
        if (Number.class.isAssignableFrom(columnClazz) && !StringUtils.isEmpty(column.getDefaultValue())) {
            Double defValue = Double.parseDouble(column.getDefaultValue());
            try {
                defValue = columnClazz.getConstructor(Long.TYPE).newInstance(defValue.longValue());
            }
            catch (Exception ex1) {
                try {
                    defValue = columnClazz.getConstructor(Integer.TYPE).newInstance(defValue.intValue());
                }
                catch (Exception ex2) {
                    try {
                        defValue = columnClazz.getConstructor(Double.TYPE).newInstance((double)defValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < model.getRowCount(); ++i) {
                Object val = model.getValueAt(i, columnIndex);
                if (val != null && !val.equals(Double.NaN)) continue;
                model.setData(defValue, i, columnIndex);
            }
        }
    }

    protected void evaluateDefault(Object defValue, Class columnClazz) {
        for (ValueParserType parserType : ValueParserType.values()) {
            AbstractValueParser valParser = this.getValueParser(parserType, defValue);
            Object valueParsed = valParser.tryParseValue();
            if (valueParsed == null) continue;
            try {
                defValue = columnClazz.getConstructor(valParser.getValueClass()).newInstance(valueParsed);
            }
            catch (Exception exception) {}
            break;
        }
    }

    protected AbstractValueParser getValueParser(ValueParserType parserType, Object val) {
        switch (parserType) {
            case LONG: {
                return new LongValueParser(val);
            }
            case INTEGER: {
                return new IntegerValueParser(val);
            }
            case DOUBLE: {
                return new DoubleValueParser(val);
            }
        }
        return null;
    }

    protected class DoubleValueParser
    extends AbstractValueParser<Double> {
        public DoubleValueParser(Object valueToParse) {
            super(valueToParse);
        }

        @Override
        protected Class<Double> getValueClass() {
            return Double.TYPE;
        }

        @Override
        protected Double tryParseValue() {
            try {
                return (double)((Double)this.value);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    protected class IntegerValueParser
    extends AbstractValueParser<Integer> {
        public IntegerValueParser(Object valueToParse) {
            super(valueToParse);
        }

        @Override
        protected Class<Integer> getValueClass() {
            return Integer.TYPE;
        }

        @Override
        protected Integer tryParseValue() {
            try {
                return (int)((Integer)this.value);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    protected class LongValueParser
    extends AbstractValueParser<Long> {
        public LongValueParser(Object valueToParse) {
            super(valueToParse);
        }

        @Override
        protected Class<Long> getValueClass() {
            return Long.TYPE;
        }

        @Override
        protected Long tryParseValue() {
            try {
                return (long)((Long)this.value);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    protected abstract class AbstractValueParser<T> {
        protected final Object value;

        public AbstractValueParser(Object valueToParse) {
            this.value = valueToParse;
        }

        protected abstract Class<T> getValueClass();

        protected abstract T tryParseValue();
    }

    protected static enum ValueParserType {
        LONG,
        INTEGER,
        DOUBLE;

    }
}

