/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportSearchParams;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.column.CustomReportColumn;
import ordermate.database.reports.config.custom.column.CustomReportColumnType;
import ordermate.database.reports.config.custom.column.derived.DerivedReportColumn;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.column.direct.DirectReportColumn;
import ordermate.database.reports.config.custom.compiler.BaseReportCompilerFactory;
import ordermate.database.reports.config.custom.compiler.CustomReportTableModel;
import ordermate.database.reports.config.custom.compiler.DefaultBaseReportCompilerFactory;
import ordermate.database.reports.config.custom.compiler.DerivedColumnStuffer;
import ordermate.database.reports.config.custom.compiler.DirectColumnStuffer;
import ordermate.database.reports.config.group.GroupingBaseReportCompiler;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class CustomReportCompiler {
    private final CustomReportSearchParams params;
    private TableModel masterTableModel;
    private Map<CustomReportSeries, CustomReportTableModel> seriesReportMap;
    private List<CustomReportCompiler> subCompilers = new ArrayList<CustomReportCompiler>();

    public CustomReportCompiler(CustomReport report) {
        this(new CustomReportSearchParams(report));
    }

    public CustomReportCompiler(CustomReportSearchParams yourParameters) {
        if (yourParameters == null || yourParameters.getCustomReport() == null) {
            throw new IllegalArgumentException("Custom Report Compiler must have a report");
        }
        this.params = yourParameters;
    }

    public CustomReport getReport() {
        return this.params.getCustomReport();
    }

    public void setReportDate(Date theDate) {
        this.params.getDateFilter().setSearchValue(theDate);
    }

    public Date getReportDate() {
        return (Date)this.params.getDateFilter().getSearchValue();
    }

    public void setPeriodReportAdapter(PeriodReportAdapter adapter) {
        this.params.setPeriod(adapter);
    }

    public PeriodReportAdapter getPeriodAdapter() {
        return this.params.getPeriod();
    }

    public TableModel getMasterTableModel() {
        return this.masterTableModel;
    }

    public void compileReport() {
        if (this.seriesReportMap != null) {
            throw new IllegalStateException("Cannot call compile more than once. Either re-use the results or throw away this compiler");
        }
        Map<String, BaseReportCompiler> compilers = this.createCompilers();
        this.runCompilers(compilers.values());
        CustomReportTableModel masterModel = this.createMasterTableModel(compilers);
        this.masterTableModel = masterModel;
        Map<CustomReportSeries, CustomReportTableModel> seriesData = this.createTableModels(masterModel);
        this.seriesReportMap = seriesData;
        this.subCompilers.clear();
        for (CustomReport subReport : this.getReport().getSubReports()) {
            CustomReportCompiler subCompiler = this.createCustomReportCompiler(subReport);
            subCompiler.setPeriodReportAdapter(this.getPeriodAdapter());
            subCompiler.setReportDate(this.getReportDate());
            subCompiler.compileReport();
            this.subCompilers.add(subCompiler);
        }
    }

    protected CustomReportCompiler createCustomReportCompiler(CustomReport report) {
        return new CustomReportCompiler(report);
    }

    public List<CustomReportCompiler> getSubReportCompilers() {
        return this.subCompilers;
    }

    private Map<CustomReportSeries, CustomReportTableModel> createTableModels(CustomReportTableModel masterTable) {
        HashMap<CustomReportSeries, CustomReportTableModel> map = new HashMap<CustomReportSeries, CustomReportTableModel>();
        for (CustomReportSeries series : this.getReport().getSeries()) {
            CustomReportTableModel seriesTableModel = new CustomReportTableModel(series, masterTable);
            map.put(series, seriesTableModel);
        }
        return map;
    }

    protected Map<String, BaseReportCompiler> createCompilers() {
        HashMap<String, BaseReportCompiler> compilers = new HashMap<String, BaseReportCompiler>();
        compilers.put(BaseReport.Group.name(), new GroupingBaseReportCompiler(this.getReport().getGrouping()));
        BaseReportCompilerFactory factory = this.createBaseReportCompilerFactory();
        Collection<String> reqCols = this.getReport().getRequiredColumns();
        for (CustomReportColumn column : this.getReport().getSequencedColumns()) {
            if (!(column instanceof DirectReportColumn)) continue;
            String reportKey = this.createReportKey(((DirectReportColumn)column).getBaseReport(), ((DirectReportColumn)column).getSubType());
            ((DirectReportColumn)column).setReportKey(reportKey);
            if (compilers.containsKey(reportKey)) continue;
            BaseReportCompiler compiler = factory.createCompiler(((DirectReportColumn)column).getBaseReport(), ((DirectReportColumn)column).getSubType());
            compiler.applyColumnRestriction(reqCols);
            compilers.put(reportKey, compiler);
        }
        return compilers;
    }

    protected BaseReportCompilerFactory createBaseReportCompilerFactory() {
        return new DefaultBaseReportCompilerFactory();
    }

    private void runCompilers(Collection<BaseReportCompiler> compilers) {
        for (BaseReportCompiler compiler : compilers) {
            compiler.setDate(this.getReportDate());
            compiler.setPeriod(this.getPeriodAdapter());
            compiler.setGrouping(this.getReport().getGrouping());
            compiler.applyQueryPart(this.getReport().getQueryParts());
            compiler.compile();
        }
    }

    private CustomReportTableModel createMasterTableModel(Map<String, BaseReportCompiler> compilers) {
        GroupingBaseReportCompiler groupCompiler = (GroupingBaseReportCompiler)compilers.get(BaseReport.Group.name());
        Set<Object> identifiers = groupCompiler.getRowIdentifiers();
        List<CustomReportColumn> columns = this.getReport().getSequencedColumns();
        String[] names = new String[columns.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = columns.get(i).getLabel();
        }
        CustomReportTableModel masterTable = new CustomReportTableModel(names);
        masterTable.initData(identifiers.size());
        if (masterTable.getRowCount() > 0) {
            DirectColumnStuffer directStuffer = new DirectColumnStuffer();
            DerivedColumnStuffer derivedStuffer = new DerivedColumnStuffer(this.getReport());
            ArrayList<CustomReportColumn> removeIfNulls = new ArrayList<CustomReportColumn>();
            for (CustomReportColumn column : columns) {
                if (!CustomReportColumnType.Direct.equals((Object)column.getColumnType())) continue;
                directStuffer.stuffColumn((DirectReportColumn)column, compilers, identifiers, masterTable);
                if (!((DirectReportColumn)column).isRemoveIfNull()) continue;
                removeIfNulls.add(column);
            }
            for (CustomReportColumn column : columns) {
                if (!CustomReportColumnType.Derived.equals((Object)column.getColumnType())) continue;
                derivedStuffer.stuffColumn((DerivedReportColumn)column, null, identifiers, masterTable);
            }
            masterTable.cullNulls(removeIfNulls);
        }
        return masterTable;
    }

    public TableModel getData(CustomReportSeries series) {
        if (this.seriesReportMap == null) {
            throw new IllegalStateException("Call compile before attempting to access the reports");
        }
        return this.seriesReportMap.get(series);
    }

    protected String createReportKey(BaseReport report, String subType) {
        if (subType != null) {
            StringBuilder SB = new StringBuilder(report.name());
            if (subType != null && !subType.isEmpty()) {
                SB.append("__").append(subType);
            }
            return SB.toString();
        }
        return report.name();
    }

    public TableModel getDataFor(String dataSourceExpression) {
        for (CustomReportSeries series : this.seriesReportMap.keySet()) {
            if (!series.getDataSource().equals(dataSourceExpression)) continue;
            return this.seriesReportMap.get(series);
        }
        return null;
    }
}

