/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.compiler;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.IndexSorter;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ordermate.database.reports.config.custom.CustomReportSeries;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.config.custom.column.CustomReportColumn;

public class CustomReportTableModel
extends AbstractTableModel {
    private String[] names;
    private Object[][] data;
    private CustomReportSeries series;
    private int rows = -1;

    public CustomReportTableModel(String[] names) {
        this.series = null;
        this.names = names;
    }

    public CustomReportTableModel(CustomReportSeries yourSeries, CustomReportTableModel model) {
        this.series = yourSeries;
        this.names = model.getColumnNames();
        this.data = model.copyData();
        this.adjustData();
        if (this.series.isInvertedTable()) {
            this.invertTable();
        }
    }

    Object[][] copyData() {
        Object[][] newData = new Object[this.data.length][];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        return newData;
    }

    @Override
    public String getColumnName(int index) {
        return this.names[index];
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.names.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data[rowIndex][columnIndex];
    }

    void initData(int numRows) {
        this.data = new Object[numRows][this.names.length];
        this.rows = numRows;
    }

    void setData(Object value, int row, int column) {
        this.data[row][column] = value instanceof Price ? Double.valueOf(((Price)value).doubleValue()) : value;
    }

    private void adjustData() {
        Integer limit;
        String order = this.series.getOrdering();
        if (order != null && !order.isEmpty()) {
            List<String> splits = this.series.getOrderList();
            for (int i = splits.size() - 1; i >= 0; --i) {
                this.orderBy(this.series.getReport().getColumn(splits.get(i)));
            }
        }
        this.rows = (limit = this.series.getLimit()) != null && limit > 0 ? limit : this.data.length;
    }

    private void orderBy(CustomReportColumn column) {
        if (column == null) {
            return;
        }
        int columnIndex = this.series.getReport().getSequencedColumns().indexOf(column);
        IndexSorter sorter = new IndexSorter(columnIndex);
        if (this.data.length > 1) {
            Arrays.sort(this.data, sorter);
        }
    }

    public String[] getColumnNames() {
        return this.names;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.rows; ++i) {
            if (this.data[i][columnIndex] == null) continue;
            return this.data[i][columnIndex].getClass();
        }
        return null;
    }

    public void cullNulls(List<CustomReportColumn> removeIfNulls) {
        if (removeIfNulls == null || removeIfNulls.isEmpty()) {
            return;
        }
        int[] colIndex = new int[removeIfNulls.size()];
        int index = 0;
        block0: for (CustomReportColumn col : removeIfNulls) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.names[i].equals(col.getLabel())) continue;
                colIndex[index] = i;
                ++index;
                continue block0;
            }
        }
        ArrayList<Integer> rowsToRemove = new ArrayList<Integer>();
        block2: for (int row = 0; row < this.data.length; ++row) {
            for (int col = 0; col < removeIfNulls.size(); ++col) {
                if (this.getValueAt(row, colIndex[col]) != null) continue;
                rowsToRemove.add(row);
                continue block2;
            }
        }
        int rowCount = this.data.length - rowsToRemove.size();
        if (rowCount == this.data.length) {
            return;
        }
        if (rowCount == 0) {
            Object[][] newData = new Object[][]{this.data[0]};
            this.data = newData;
            this.rows = 1;
            return;
        }
        if (rowsToRemove != null && !rowsToRemove.isEmpty()) {
            Object[][] newData = new Object[rowCount][];
            int currentIndex = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (rowsToRemove.contains(new Integer(i))) continue;
                newData[currentIndex] = this.data[i];
                ++currentIndex;
            }
            this.data = newData;
        }
        this.rows = this.data.length;
    }

    private void invertTable() {
        CustomReportTableModelInverter inverter = new CustomReportTableModelInverter();
        inverter.invertTable();
    }

    static /* synthetic */ String[] access$102(CustomReportTableModel x0, String[] x1) {
        x0.names = x1;
        return x1;
    }

    static /* synthetic */ Object[][] access$002(CustomReportTableModel x0, Object[][] x1) {
        x0.data = x1;
        return x1;
    }

    class CustomReportTableModelInverter {
        CustomReportTableModelInverter() {
        }

        void invertTable() {
            this.preFormatData();
            this.removeInvisibleColumns();
            String[] newNames = new String[CustomReportTableModel.this.data.length + 1];
            newNames[0] = CustomReportTableModel.this.names[0];
            for (int i = 0; i < CustomReportTableModel.this.data.length; ++i) {
                newNames[i + 1] = String.valueOf(CustomReportTableModel.this.data[i][0]);
            }
            Object[][] newData = new Object[CustomReportTableModel.this.names.length - 1][CustomReportTableModel.this.data.length + 1];
            for (int i = 0; i < CustomReportTableModel.this.names.length - 1; ++i) {
                newData[i][0] = JasperReportHelper.runMaskedDBQuery(PersistenceManager.getPersistenceDelegate(), CustomReportTableModel.this.names[i + 1]);
            }
            CustomReportTableModel.access$102(CustomReportTableModel.this, newNames);
            for (int row = 0; row < newData.length; ++row) {
                for (int col = 0; col < newData[row].length - 1; ++col) {
                    newData[row][col + 1] = String.valueOf(CustomReportTableModel.this.data[col][row + 1]);
                }
            }
            CustomReportTableModel.access$002(CustomReportTableModel.this, newData);
            CustomReportTableModel.this.rows = CustomReportTableModel.this.data.length;
        }

        private void removeInvisibleColumns() {
            List<CustomReportColumn> columns = CustomReportTableModel.this.series.getReport().getColumns();
            HashSet<Integer> removes = new HashSet<Integer>();
            for (int i = 0; i < columns.size(); ++i) {
                if (columns.get(i).isVisible()) continue;
                removes.add(i);
            }
            if (removes.isEmpty()) {
                return;
            }
            String[] newNames = new String[CustomReportTableModel.this.names.length - removes.size()];
            Object[][] newData = new Object[CustomReportTableModel.this.data.length][CustomReportTableModel.this.data[0].length - removes.size()];
            int count = 0;
            for (int i = 0; i < columns.size(); ++i) {
                if (removes.contains(i)) {
                    ++count;
                    continue;
                }
                newNames[i - count] = CustomReportTableModel.this.names[i];
                for (int row = 0; row < CustomReportTableModel.this.data.length; ++row) {
                    newData[row][i - count] = CustomReportTableModel.this.data[row][i];
                }
            }
            CustomReportTableModel.access$102(CustomReportTableModel.this, newNames);
            CustomReportTableModel.access$002(CustomReportTableModel.this, newData);
        }

        private void preFormatData() {
            List<CustomReportColumn> columns = CustomReportTableModel.this.series.getReport().getColumns();
            for (int col = 1; col < columns.size(); ++col) {
                Format format;
                CustomReportColumn column = columns.get(col);
                if (!column.isVisible() || StringUtils.isEmpty(column.getFormat()) || (format = this.determineFormat(col, column.getFormat())) == null) continue;
                for (int row = 0; row < CustomReportTableModel.this.data.length; ++row) {
                    ((CustomReportTableModel)CustomReportTableModel.this).data[row][col] = format.format(CustomReportTableModel.this.data[row][col]).replaceAll("\\$", "");
                }
            }
        }

        private Format determineFormat(int col, String formatString) {
            if (CustomReportTableModel.this.data.length == 0) {
                return null;
            }
            Object value = CustomReportTableModel.this.data[0][col];
            if (value == null) {
                for (int i = 1; i < CustomReportTableModel.this.data.length && (value = CustomReportTableModel.this.data[i][col]) == null; ++i) {
                }
            }
            if (value instanceof Number) {
                return new DecimalFormat(formatString);
            }
            if (value instanceof Date) {
                return new SimpleDateFormat(formatString);
            }
            return null;
        }
    }
}

