/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.compiler;

import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.adj.BaseAdjustmentCompiler;
import ordermate.database.reports.config.adj.BaseAdjustmentsByTypeCompiler;
import ordermate.database.reports.config.adj.BaseComboAdjustmentCompiler;
import ordermate.database.reports.config.cogs.BaseCogsCompiler;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.config.custom.compiler.BaseReportCompilerFactory;
import ordermate.database.reports.config.custom.parameter.BaseCustomParametersCompiler;
import ordermate.database.reports.config.debtors.BaseDebtorPaymentCompiler;
import ordermate.database.reports.config.debtors.BaseDebtorSalesCompiler;
import ordermate.database.reports.config.group.GroupingBaseReportCompiler;
import ordermate.database.reports.config.itemstate.BaseItemStateCompiler;
import ordermate.database.reports.config.labour.BaseLabourCompiler;
import ordermate.database.reports.config.patrons.BasePPACompiler;
import ordermate.database.reports.config.patrons.BasePatronsByAccountTypeCompiler;
import ordermate.database.reports.config.patrons.BasePatronsByAdjustmentCompiler;
import ordermate.database.reports.config.patrons.BasePatronsCompiler;
import ordermate.database.reports.config.reconciliation.BaseReconciliationCompiler;
import ordermate.database.reports.config.sales.BaseSalesCompiler;
import ordermate.database.reports.config.sales.BaseSalesHistoryCompiler;
import ordermate.database.reports.config.salesbreakdown.BaseSalesBreakdownCompiler;
import ordermate.database.reports.config.takings.BaseTakingsCompiler;
import ordermate.database.reports.config.voucher.BaseVoucherCompiler;

public class DefaultBaseReportCompilerFactory
implements BaseReportCompilerFactory {
    @Override
    public BaseReportCompiler createCompiler(BaseReport report, String subType) {
        AbstractBaseReportCompiler compiler;
        switch (report) {
            case Sales: {
                compiler = new BaseSalesHistoryCompiler();
                break;
            }
            case Patrons: {
                compiler = new BasePatronsByAccountTypeCompiler();
                break;
            }
            case Labour: {
                compiler = new BaseLabourCompiler();
                break;
            }
            case COGS: {
                compiler = new BaseCogsCompiler();
                break;
            }
            case Group: {
                compiler = new GroupingBaseReportCompiler(BaseReportGrouping.None);
                break;
            }
            case SalesBreakdown: {
                compiler = new BaseSalesBreakdownCompiler();
                break;
            }
            case Adjustments: {
                compiler = new BaseAdjustmentCompiler();
                break;
            }
            case ComboAdjustments: {
                compiler = new BaseComboAdjustmentCompiler();
                break;
            }
            case AdjustmentsByType: {
                compiler = new BaseAdjustmentsByTypeCompiler();
                break;
            }
            case Takings: {
                compiler = new BaseTakingsCompiler();
                break;
            }
            case DebtorPayment: {
                compiler = new BaseDebtorPaymentCompiler();
                break;
            }
            case DebtorSales: {
                compiler = new BaseDebtorSalesCompiler();
                break;
            }
            case Reconciliation: {
                compiler = new BaseReconciliationCompiler();
                break;
            }
            case Vouchers: {
                compiler = new BaseVoucherCompiler();
                break;
            }
            case ItemState: {
                compiler = new BaseItemStateCompiler();
                break;
            }
            case NewSales: {
                compiler = new BaseSalesCompiler();
                break;
            }
            case PPA: {
                compiler = new BasePPACompiler();
                break;
            }
            case PatronsByUser: {
                compiler = new BasePatronsCompiler();
                break;
            }
            case CustomParameters: {
                compiler = new BaseCustomParametersCompiler();
                break;
            }
            case PatronsByAdjustment: {
                compiler = new BasePatronsByAdjustmentCompiler();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type of base compiler. Please implement.");
            }
        }
        compiler.setSubType(subType);
        return compiler;
    }
}

