/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.custom.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.io.PersistentObjectIO;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.CustomReportIO;
import ordermate.database.reports.config.custom.manager.CustomReportManagerRemote;

public class CustomReportManager
extends UnicastRemoteObject
implements CustomReportManagerRemote {
    public static final String REPORT_PROP_CUSTOM_REPORT_DIR = "Custom Report Directory";
    protected static final String DEFAULT_PATH_TO_REPORTS = "C:\\customreports\\";
    private static final String EXT_REP = ".rep";
    private static final String EXT_XML = ".xml";
    private static CustomReportManager instance;
    private final List<CustomReport> reports = new ArrayList<CustomReport>();

    public static CustomReportManager getInstance() {
        if (instance == null) {
            try {
                instance = new CustomReportManager();
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Failed to construct CustomReportManager!", (Throwable)e);
            }
        }
        return instance;
    }

    protected CustomReportManager() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshAvailableReports() throws RemoteException {
        File directory = new File(this.getPathToCustomReports());
        if (!directory.exists()) {
            directory.mkdirs();
            return;
        }
        OrderMate.LOG.info("Refreshing available custom reports from " + directory.getAbsolutePath());
        if (directory.listFiles().length != 0) {
            this.reports.clear();
        }
        PersistentObjectIO newIO = new PersistentObjectIO(true);
        for (File file : directory.listFiles()) {
            if (!file.getName().toLowerCase().endsWith(EXT_REP) && !file.getName().toLowerCase().endsWith(EXT_XML)) continue;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                OrderMate.LOG.info("Reading in report: " + file.getName());
                this.reports.add((CustomReport)newIO.readIn(inputStream));
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Failed to read in custom report from XML, trying old school method");
                try {
                    CustomReportIO oldIO = new CustomReportIO();
                    this.reports.add(oldIO.readIn(inputStream));
                }
                catch (Exception e2) {
                    OrderMate.LOG.warn("Couldn't read in custom report using old school method from " + file.getAbsolutePath(), (Throwable)e2);
                }
            }
            finally {
                this.closeStream(inputStream);
            }
        }
    }

    @Override
    public List<CustomReport> getAvailableCustomReports() throws RemoteException {
        return Collections.unmodifiableList(this.reports);
    }

    protected final String getPathToCustomReports() {
        return ReportProperty.find(ReportGroup.General, REPORT_PROP_CUSTOM_REPORT_DIR).getStringValue(DEFAULT_PATH_TO_REPORTS);
    }

    private void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

