/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;

public class BaseDebtorPaymentSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseDebtorPaymentSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.count(DebtorPayment.class, "count_payments").sum(DebtorPayment.Properties.AMOUNT, "total_payments");
        query.selectFunc("SUM( IF(finance_transaction.amount_paid < 0, debtor_payment.amount, 0)) as total_refunded_payments ").select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day");
        query.linkUsing(DebtorPayment.Properties.TERMINAL).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION).linkUsing(FinanceTransaction.Properties.SALES_LOCATION).linkUsing(FinanceTransaction.Properties.TRADING_DAY).linkUsing(DebtorPayment.Properties.DEBTOR).active(FinanceTransaction.class);
        for (Pair<Object, String> nextPair : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(debtor.fk_debtor_group = ");
                SB.append(nextPair.key).append(", 1, 0)) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(debtor.fk_debtor_group = ");
            SB.append(nextPair.key).append(", amount, 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("count_payments", "total_payments", "total_refunded_payments", "location", "trading_day");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM debtor_group dg where dg.system_state = 'ACTIVE' ORDER BY dg.Name";
    }
}

