/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.util.Pair;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.config.DynamicColumnSearcher;
import ordermate.database.sales.Account;

public class BaseDebtorSalesSearcher
extends DynamicColumnSearcher {
    private RangeQuerySearchFilter<Date> dayFilter;

    public BaseDebtorSalesSearcher() {
        this.dayFilter = new RangeQuerySearchFilter(TradingDay.Properties.DATE);
        this.addSearchFilter(this.dayFilter);
    }

    public RangeQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.dayFilter;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        ObjectQuery query = Query.count(DebtorSale.class, "count_sales").sum(DebtorSale.Properties.TOTAL, "total_sales");
        query.selectFunc("SUM(IF(sales_account.account_type = 'REFUND', debtor_sale.total, 0)) as total_refunded_sales ").select(SalesLocation.Properties.LABEL, "location").select(TradingDay.Properties.DATE, "trading_day");
        query.linkUsing(DebtorSale.Properties.TERMINAL).linkUsing(Terminal.Properties.SALES_LOCATION).linkUsing(DebtorSale.Properties.SALE_ACCOUNT).linkUsing(Account.Properties.TRADING_DAY).linkUsing(DebtorSale.Properties.DEBTOR);
        for (Pair<Object, String> nextPair : this.getDynamicColumns()) {
            StringBuilder SB;
            if (((String)nextPair.value).endsWith("_count")) {
                SB = new StringBuilder("SUM(IF(debtor.fk_debtor_group = ");
                SB.append(nextPair.key).append(", 1, 0)) as `").append((String)nextPair.value).append("`");
                query.selectFunc(SB.toString());
                continue;
            }
            if (!((String)nextPair.value).endsWith("_total")) continue;
            SB = new StringBuilder("ROUND(SUM(IF(debtor.fk_debtor_group = ");
            SB.append(nextPair.key).append(", total, 0)), 2) as `").append((String)nextPair.value).append("`");
            query.selectFunc(SB.toString());
        }
        return query;
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList("count_sales", "total_sales", "total_refunded_sales", "location", "trading_day");
    }

    @Override
    protected String getColumnNamePairSQL() {
        return "SELECT ID, Name FROM debtor_group dg where dg.system_state = 'ACTIVE' ORDER BY dg.Name";
    }
}

