/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.config.group;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.Searcher;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.reports.config.AbstractBaseReportCompiler;
import ordermate.database.reports.config.BaseReportGrouping;
import ordermate.database.reports.config.custom.column.direct.BaseReport;
import ordermate.database.reports.general.StringReport;
import ordermate.database.searchers.ComparableMultiKey;

public class GroupingBaseReportCompiler
extends AbstractBaseReportCompiler {
    public static final String ID = "Id";
    public static final String STRING = "Label";
    private final BaseReportGrouping grouping;
    private Map<Object, Pair> rowIds;

    public GroupingBaseReportCompiler(BaseReportGrouping yourGrouping) {
        this.grouping = yourGrouping;
    }

    @Override
    public void compile() {
        if (this.grouping == null || BaseReportGrouping.None.equals((Object)this.grouping)) {
            List<String> groups = this.getExtraGroups();
            this.rowIds = groups != null && !groups.isEmpty() ? this.doCustomGrouping(groups) : Collections.singletonMap(null, new Pair<Object, String>(null, "Total"));
        } else if (BaseReportGrouping.TradingDay.equals((Object)this.grouping)) {
            this.rowIds = this.doTradingDayGrouping();
        } else if (BaseReportGrouping.SalesLocation.equals((Object)this.grouping)) {
            this.rowIds = this.doSalesLocationGrouping();
        } else if (BaseReportGrouping.StoreId.equals((Object)this.grouping)) {
            this.rowIds = this.doStoreGrouping();
        }
    }

    private Map<Object, Pair> doCustomGrouping(List<String> groupNames) {
        StringBuilder SB = new StringBuilder("SELECT ");
        SB.append(StringUtils.mergeWithSeparator(groupNames, ", "));
        SB.append(" FROM ");
        for (String next : groupNames) {
            SB.append(next.split("\\.")[0]).append(", ");
        }
        SB.replace(SB.length() - 2, SB.length(), "");
        SB.append("\r\n ORDER BY ");
        SB.append(StringUtils.mergeWithSeparator(groupNames, ", "));
        LinkedHashMap<Object, Pair> pairMap = new LinkedHashMap<Object, Pair>();
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(SB.toString(), new Object[0]);
        if (groupNames.size() == 1) {
            for (Object[] nextSet : results) {
                pairMap.put(nextSet[0], new Pair<Object[], String>(nextSet, String.valueOf(nextSet[0])));
            }
        } else {
            for (Object[] nextSet : results) {
                pairMap.put(new ComparableMultiKey(nextSet), new Pair<Object[], String>(nextSet, StringUtils.mergeToStringWithSeparator(Arrays.asList(nextSet), ", ", null)));
            }
        }
        return pairMap;
    }

    protected Map<Object, Pair> doTradingDayGrouping() {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yy");
        LinkedHashMap<Object, Pair> pairMap = new LinkedHashMap<Object, Pair>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getStartDate());
        Date endDate = this.getEndDate();
        Date currentDate = cal.getTime();
        while (currentDate.before(endDate)) {
            pairMap.put(currentDate, new Pair<Date, String>(currentDate, format.format(currentDate)));
            cal.add(5, 1);
            currentDate = cal.getTime();
        }
        return pairMap;
    }

    protected Map<Object, Pair> doSalesLocationGrouping() {
        LinkedHashMap<Object, Pair> pairMap = new LinkedHashMap<Object, Pair>();
        List<SalesLocation> locs = PersistenceManager.getObjectList(SalesLocation.class, Query.select(SalesLocation.class).toString());
        for (SalesLocation termLoc : locs) {
            pairMap.put(termLoc.getID(), new Pair<Long, String>(termLoc.getID(), termLoc.getLabel()));
        }
        return pairMap;
    }

    protected Map<Object, Pair> doStoreGrouping() {
        LinkedHashMap<Object, Pair> pairMap = new LinkedHashMap<Object, Pair>();
        String query = "SELECT id, name as 'value', 0 as 'store_id', 0 as mod_count from ho_config_store where system_state <> 'DELETED'";
        List<StringReport> reports = PersistenceManager.getObjectList(StringReport.class, query);
        for (StringReport report : reports) {
            pairMap.put(report.getID(), new Pair<Long, String>(report.getID(), report.getValue()));
        }
        return pairMap;
    }

    @Override
    public Set<Object> getRowIdentifiers() {
        return new LinkedHashSet<Object>(this.rowIds.keySet());
    }

    @Override
    public Object getValue(Object rowId, String column) {
        if (ID.equals(column)) {
            return rowId;
        }
        if (STRING.equals(column)) {
            return this.rowIds.get((Object)rowId).value;
        }
        return null;
    }

    @Override
    public List<String> getDirectColumns() {
        return Arrays.asList(ID, STRING);
    }

    @Override
    protected Searcher createSearcher() {
        return null;
    }

    @Override
    public BaseReport getBaseReport() {
        return BaseReport.Group;
    }
}

